<?php
    use Illuminate\Support\Facades\Route;

    Route::get('/', 'Frontend\FrontendEndController@index')->name('frontend_index');
    Route::group(['prefix' => '/hospital', 'namespace' => 'Frontend'], function () {
        Route::get('/about', 'FrontendEndController@about')->name('frontend_about');

        Route::get('/contact', 'FrontendEndController@contact')->name('frontend_contact');
        Route::post('/contact_submit', 'FrontendEndController@contact_submit')->name('frontend_contact_submit');

        Route::get('/department', 'FrontendEndController@department')->name('frontend_department');
        Route::get('/department-details', 'FrontendEndController@department_details')->name('frontend_department_details');

        Route::get('/doctor', 'FrontendEndController@doctor')->name('frontend_doctor');
        Route::get('/doctor-details/{slug}', 'FrontendEndController@doctor_details')->name('frontend_doctor_details');
        Route::get('/doctor-appoinment', 'FrontendEndController@doctor_appoinment')->name('frontend_doctor_appoinment');
        Route::post('/doctor-appoinment_submit', 'FrontendEndController@doctor_appoinment_submit')->name('frontend_doctor_appoinment_submit');

        Route::get('/blog', 'FrontendEndController@blog')->name('frontend_blog');
        Route::get('/blog-details', 'FrontendEndController@blog_details')->name('frontend_blog_details');

    });
