<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <base href="/contents/website/">
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="">
    <meta name="author" content="Rizvi">
    <meta name="keyword" content="Php, Hospital, Clinic, Management, Software, Php, CodeIgniter, Hms, Accounting">
    <link rel="shortcut icon" href="{{ asset('contents/frontend') }}/img/tlogo.png">
    <title>Department | Hospital Management System </title>
    <!-- Bootstrap core CSS -->
    <link href="common/css/bootstrap.min.css" rel="stylesheet">
    <link href="common/css/bootstrap-reset.css" rel="stylesheet">
    <!--external css-->
    <link href="common/assets/fontawesome5pro/css/all.min.css" rel="stylesheet" />
    <link href="common/assets/DataTables/datatables.min.css" rel="stylesheet" />
    <!-- <link href="common/assets/font-awesome/css/font-awesome.css" rel="stylesheet" /> -->
    <!-- Custom styles for this template -->
    <link href="common/css/style.css" rel="stylesheet">
    <link href="common/css/style-responsive.css" rel="stylesheet" />
    <link rel="stylesheet" href="common/assets/bootstrap-datepicker/css/datepicker.css" />
    <link rel="stylesheet" type="text/css" href="common/assets/bootstrap-daterangepicker/daterangepicker-bs3.css" />
    <link rel="stylesheet" type="text/css" href="common/assets/bootstrap-datetimepicker/css/datetimepicker.css" />
    <link rel="stylesheet" type="text/css" href="common/assets/bootstrap-timepicker/compiled/timepicker.css">
    <link rel="stylesheet" type="text/css" href="common/assets/jquery-multi-select/css/multi-select.css" />
    <link rel="stylesheet" href="/contents/admin/assets/plugins/summernote/dist/summernote-bs42.css" />
    <link href="common/css/invoice-print.css" rel="stylesheet" media="print">
    <link href="common/assets/fullcalendar/fullcalendar.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="common/assets/select2/css/select2.min.css" />
    <link rel="stylesheet" type="text/css" href="common/css/lightbox.css" />
    <link rel="stylesheet" type="text/css" href="common/assets/bootstrap-fileupload/bootstrap-fileupload.css" />
    <link rel="stylesheet" type="text/css" href="common/assets/bootstrap-wysihtml5/bootstrap-wysihtml5.css" />

    <link rel="stylesheet" type="text/css"
        href="common/assets/DataTables/DataTables-1.10.16/custom/css/datatable-responsive-cdn-version-1-0-7.css" />
    <!-- Google Fonts -->
    <style>
        @import url('https://fonts.googleapis.com/css?family=Ubuntu&display=swap');

    </style>
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js" integrity="sha256-4+XzXVhsDmqanXGHaHvgh1gMQKX40OUvDEBTu8JcmNs=" crossorigin="anonymous"></script>

    <!-- HTML5 shim and Respond.js IE8 support of HTML5 tooltipss and media queries -->
    <!--[if lt IE 9]>
          <script src="js/html5shiv.js"></script>
          <script src="js/respond.min.js"></script>
        <![endif]-->

    <link rel="stylesheet" href="{{ asset('contents/website/custom.css') }}">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@9"></script>
</head>

<body>
    @include('include.flash')
    <section id="container" class="">
        <!--header start-->
        <header class="header white-bg">
            <div class="sidebar-toggle-box">
                <div data-original-title="Toggle Navigation" data-placement="right"
                    class="fa fa-dedent fa-bars fa-angle-double-left tooltips"></div>
            </div>
            <!--logo start-->

            <a href="/hms" class="logo">
                <img src="{{ asset('tlogo.png') }}" style="height: 40px;" alt="HMS">
            </a>

            <!--logo end-->
            <div class="nav notify-row" id="top_menu">
                <!--  notification start -->
                <ul class="nav top-menu">
                    <!-- Bed Notification start -->

                    <li class="dropdown">
                        <a data-toggle="dropdown" class="dropdown-toggle" href="#">
                            <i class="fa fa-procedures"></i>
                            <span class="badge bg-success">
                                0
                            </span>
                        </a>
                        <ul class="dropdown-menu extended tasks-bar">
                            <div class="notify-arrow notify-arrow-green"></div>
                            <li>
                                <p class="green">
                                    0
                                    Bed Is Available </p>
                            </li>
                            <li class="external">
                                <a href="bed/bedAllotment">
                                    <p class="green">No bed is available for allotment</p>
                                </a>
                            </li>
                        </ul>
                    </li>
                    <!-- Bed notification end -->
                    <!-- Payment notification start-->

                    <li id="header_inbox_bar" class="dropdown">
                        <a data-toggle="dropdown" class="dropdown-toggle" href="#">
                            <i class="fa fa-money-check"></i>
                            <span class="badge bg-important">
                                0
                            </span>
                        </a>
                        <ul class="dropdown-menu extended inbox">
                            <div class="notify-arrow notify-arrow-red"></div>
                            <li>
                                <p class="red"> 0 Payment Today</p>
                            </li>
                            <li>
                                <a href="finance/payment">
                                    <p class="green"> See All Payments</p>
                                </a>
                            </li>
                        </ul>
                    </li>
                    <!-- payment notification end -->
                    <!-- patient notification start-->

                    <li id="header_notification_bar" class="dropdown">
                        <a data-toggle="dropdown" class="dropdown-toggle" href="#">
                            <i class="fa fa-user"></i>
                            <span class="badge bg-warning">
                                0 </span>
                        </a>
                        <ul class="dropdown-menu extended notification">
                            <div class="notify-arrow notify-arrow-yellow"></div>
                            <li>
                                <p class="yellow">0 Patient Registered Today </p>
                            </li>
                            <li>
                                <a href="patient">
                                    <p class="green">See All Patients</p>
                                </a>
                            </li>
                        </ul>
                    </li>
                    <!-- patient notification end -->
                    <!-- donor notification start-->

                    <li id="header_notification_bar" class="dropdown">
                        <a data-toggle="dropdown" class="dropdown-toggle" href="#">
                            <i class="fa fa-user"></i>
                            <span class="badge bg-success">
                                0 </span>
                        </a>
                        <ul class="dropdown-menu extended notification">
                            <div class="notify-arrow notify-arrow-yellow"></div>
                            <li>
                                <p class="green">0 Donor Registered Today </p>
                            </li>
                            <li>
                                <a href="donor">
                                    <p class="green">See All Donors</p>
                                </a>
                            </li>
                        </ul>
                    </li>

                    <!-- donor notification end -->
                    <!-- medicine notification start-->

                    <li id="header_notification_bar" class="dropdown">
                        <a data-toggle="dropdown" class="dropdown-toggle" href="#">
                            <i class="fa fa-medkit"></i>
                            <span class="badge bg-success">
                                0 </span>
                        </a>
                        <ul class="dropdown-menu extended notification">
                            <div class="notify-arrow notify-arrow-yellow"></div>
                            <li>
                                <p class="yellow">0 Medicine Registered Today </p>
                            </li>
                            <li>
                                <a href="medicine">
                                    <p class="green">See All Medicine</p>
                                </a>
                            </li>
                        </ul>
                    </li>

                    <!-- medicine notification end -->
                    <!-- report notification start-->

                    <li id="header_notification_bar" class="dropdown">
                        <a data-toggle="dropdown" class="dropdown-toggle" href="#">
                            <i class="fa fa-notes-medical"></i>
                            <span class="badge bg-success">
                                0 </span>
                        </a>
                        <ul class="dropdown-menu extended notification">
                            <div class="notify-arrow notify-arrow-yellow"></div>
                            <li>
                                <p class="yellow">0 Report Added Today </p>
                            </li>
                            <li>
                                <a href="report">
                                    <p class="green">See All Reports</p>
                                </a>
                            </li>
                        </ul>
                    </li>
                    <!-- report notification end -->
                </ul>
            </div>
            <div class="top-nav ">

                <ul class="nav pull-right top-menu">
                    <!-- user login dropdown start-->
                    <li class="dropdown">
                        <a data-toggle="dropdown" class="dropdown-toggle" href="#">
                            <img alt="" src="uploads/favicon.png" width="21" height="23">
                            <span class="username">
                                {{ Auth::user()->name }}
                            </span>
                            <b class="caret"></b>
                        </a>
                        <ul class="dropdown-menu extended logout">
                            <div class="log-arrow-up"></div>
                            <li><a href="/profile"><i class=" fa fa-suitcase"></i>Profile</a></li>

                            <li><a href="/profile"><i class="fa fa-cog"></i> Settings</a></li>

                            <li><a><i class="fa fa-user"></i> admin</a></li>
                            <li>
                                <a href="{{ route('logout') }}" onclick="event.preventDefault();
                                    document.getElementById('logout-form').submit();">
                                    <i class="fa fa-key"></i>
                                    Log Out
                                </a>
                            </li>
                        </ul>
                    </li>
                    <!-- user login dropdown end -->
                </ul>

            </div>
        </header>
        <!--header end-->
        <!--sidebar start-->

        @if (Auth::user()->role_id <= 2)
            @include('layouts.website.main_navbar')
        @endif

        {{-- receptionist --}}
        @if (Auth::user()->role_id == 10)
            @include('layouts.website.receptionist_navbar')
        @endif

        {{-- doctor --}}
        @if (Auth::user()->role_id == 4)
            @include('layouts.website.doctor_navbar')
        @endif

        {{-- pharmacist --}}
        @if (Auth::user()->role_id == 5)
            @include('layouts.website.nurse_navbar')
        @endif

        {{-- pharmacist --}}
        @if (Auth::user()->role_id == 6)
            @include('layouts.website.pharmacist_navbar')
        @endif

        {{-- accountant --}}
        @if (Auth::user()->role_id == 7)
            @include('layouts.website.accountant_navbar')
        @endif

        {{-- patient --}}
        @if (Auth::user()->role_id == 8)
            @include('layouts.website.patient_navbar')
        @endif

        {{-- laboratorist --}}
        @if (Auth::user()->role_id == 9)
            @include('layouts.website.laboratorist_navbar')
        @endif

        @yield('content')


        <div class="modal fade" id="modal-animation-1" style="display: none;" aria-hidden="true">
            <div class="modal-dialog ">
                <div class="modal-content animated flipInX">
                    <div class="modal-header">
                        <h5 class="modal-title"><i class="fa fa-trash text-danger"></i> Delete</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <h6>Sure want to delte?</h6>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-light" data-dismiss="modal"><i class="fa fa-times"></i>
                            Close</button>
                        <a href="" id="delete_confirm_btn" class="btn btn-danger"><i class="fa fa-check-square-o"></i> Save
                            changes</a>
                    </div>
                </div>
            </div>
        </div>


        <script src="common/js/codearistos.min.js"></script>

        <footer class="site-footer">
            <div class="container">
                <div class="row" style="justify-content:between">
                    <span class="col-md-6 text-left">© 2021 Smart Care. </span>
                    <span class="com-md-6">Development, Support and Maintenance by:<a style="color:red;" target="_blank" href="http://www.hsblco.com"> HSBLCO Solution</a></span>
                </div>
            </div>
        </footer>
        <!--footer end-->

        <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
            @csrf
        </form>

    </section>

    <!-- js placed at the end of the document so the pages load faster -->
    <script src="common/js/jquery.js"></script>
    <script src="common/js/jquery-1.8.3.min.js"></script>
    <script src="common/js/bootstrap.min.js"></script>
    <script src="common/js/jquery.scrollTo.min.js"></script>
    <script src="common/js/moment.min.js"></script>

    <!--
        <script src="common/js/jquery.nicescroll.js" type="text/javascript"></script>
    -->

    <script type="text/javascript" src="common/assets/DataTables/datatables.min.js"></script>
    <script src="common/js/respond.min.js"></script>
    <script type="text/javascript" src="common/assets/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
    <script type="text/javascript" src="common/assets/bootstrap-datetimepicker/js/bootstrap-datetimepicker.js"></script>
    <script type="text/javascript" src="common/assets/bootstrap-timepicker/js/bootstrap-timepicker.js"></script>
    <script type="text/javascript" src="common/assets/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>

    <script type="text/javascript" src="common/assets/jquery-multi-select/js/jquery.multi-select.js"></script>
    <script type="text/javascript" src="common/assets/jquery-multi-select/js/jquery.quicksearch.js"></script>
    <script type="text/javascript" src="common/assets/bootstrap-wysihtml5/bootstrap-wysihtml5.js"></script>
    <script src="common/js/advanced-form-components.js"></script>
    <script src="common/js/jquery.cookie.js"></script>
    <!--common script for all pages-->
    <script src="common/js/common-scripts.js"></script>
    <script src="common/js/lightbox.js"></script>
    <script class="include" type="text/javascript" src="common/js/jquery.dcjqaccordion.2.7.js"></script>
    <!--script for this page only-->
    <script src="common/js/editable-table.js"></script>
    <script src="common/assets/fullcalendar/fullcalendar.js"></script>
    <script type="text/javascript" src="common/assets/bootstrap-fileupload/bootstrap-fileupload.js"></script>
    <script src='common/assets/fullcalendar/locale/en.js'></script>
    <script src="common/assets/DataTables/DataTables-1.10.16/custom/js/datatable-responsive-cdn-version-2-2-5.js">
    </script>
    <script type="text/javascript" src="common/assets/select2/js/select2.min.js"></script>
    <script src="/contents/admin/assets/plugins/summernote/dist/summernote-bs4.min.js"></script>


    <script>
        $('.multi-select').multiSelect({
            selectableHeader: "<input type='text' class='search-input' autocomplete='off' placeholder=' search...'>",
            selectionHeader: "<input type='text' class='search-input' autocomplete='off' placeholder=''>",
            afterInit: function(ms) {
                var that = this,
                    $selectableSearch = that.$selectableUl.prev(),
                    $selectionSearch = that.$selectionUl.prev(),
                    selectableSearchString = '#' + that.$container.attr('id') +
                    ' .ms-elem-selectable:not(.ms-selected)',
                    selectionSearchString = '#' + that.$container.attr('id') +
                    ' .ms-elem-selection.ms-selected';

                that.qs1 = $selectableSearch.quicksearch(selectableSearchString)
                    .on('keydown', function(e) {
                        if (e.which === 40) {
                            that.$selectableUl.focus();
                            return false;
                        }
                    });

                that.qs2 = $selectionSearch.quicksearch(selectionSearchString)
                    .on('keydown', function(e) {
                        if (e.which == 40) {
                            that.$selectionUl.focus();
                            return false;
                        }
                    });
            },
            afterSelect: function() {
                this.qs1.cache();
                this.qs2.cache();
            },
            afterDeselect: function() {
                this.qs1.cache();
                this.qs2.cache();
            }
        });
    </script>

    <script>
        $(document).ready(function () {
            var table = $('#editable-sample').DataTable({
                responsive: true,

                dom: "<'row'<'col-sm-3'l><'col-sm-5 text-center'B><'col-sm-4'f>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-5'i><'col-sm-7'p>>",
                buttons: [
                    'copyHtml5',
                    'excelHtml5',
                    'csvHtml5',
                    'pdfHtml5',
                    {
                        extend: 'print',
                        exportOptions: {
                            columns: [0, 1],
                        }
                    },
                ],

                aLengthMenu: [
                    [10, 25, 50, 100, -1],
                    [10, 25, 50, 100, "All"]
                ],
                iDisplayLength: -1,
                "order": [[0, "desc"]],

                "language": {
                    "lengthMenu": "_MENU_",
                    search: "_INPUT_",
                    "url": "common/assets/DataTables/languages/english.json"
                }
            });
            table.buttons().container().appendTo('.custom_buttons');
        });
    </script>

    <script>
        $('#my_multi_select3').multiSelect()
        $('.select2').select2()
        $('.select2_mul').select2({
            'multiple' : true
        })
    </script>

    <script>
        $(function() {
            $('.description').summernote({
                height: 300,
                tabsize: 2,
                foreColor: 'blue',
                backColor: 'red'
            });
        })
    </script>

    <script type="text/javascript">
        $(document).ready(function() {
            $(".js-example-basic-single").select2();
            $(".js-example-basic-multiple").select2();
        });
    </script>

    <script type="text/javascript">
        $(document).ready(function() {
            var windowH = $(window).height();
            var wrapperH = $('#container').height();
            if (windowH > wrapperH) {
                $('#sidebar').css('height', (windowH) + 'px');
            } else {
                $('#sidebar').css('height', (wrapperH) + 'px');
            }
            var windowSize = window.innerWidth;
            if (windowSize < 768) {
                $('#sidebar').removeAttr('style');
            }
        });

        function onElementHeightChange(elm, callback) {
            var lastHeight = elm.clientHeight,
                newHeight;
            (function run() {
                newHeight = elm.clientHeight;
                if (lastHeight != newHeight)
                    callback();
                lastHeight = newHeight;
                if (elm.onElementHeightChangeTimer)
                    clearTimeout(elm.onElementHeightChangeTimer);
                elm.onElementHeightChangeTimer = setTimeout(run, 200);
            })();
        }

        onElementHeightChange(document.body, function() {
            var windowH = $(window).height();
            var wrapperH = $('#container').height();
            if (windowH > wrapperH) {
                $('#sidebar').css('height', (windowH) + 'px');
            } else {
                $('#sidebar').css('height', (wrapperH) + 'px');
            }

            var windowSize = $(window).width();
            if (windowSize < 768) {
                $('#sidebar').removeAttr('style');
            }
        });

        $(window).resize(function() {
            if (width == GetWidth()) {
                return;
            }
            width = GetWidth();
            if (width < 600) {
                $('#sidebar').hide();
            } else {
                $('#sidebar').show();
            }
        });
    </script>

    <script>
        $('.delete_button_modal').on('click',function(e){
            e.preventDefault;
            var url = $(this).data('href');
            console.log(url);
            $('#delete_confirm_btn').attr('href',url);
        })
    </script>
    @stack('cjs')
</body>

</html>
