@extends('layouts.website.website')
@section('content')
    <!--main content start-->
    <section id="main-content">
        <section class="wrapper site-min-height">
            <!-- page start-->
            <section class="panel">
                <header class="panel-heading">
                    Appointment Requests
                    <div class="col-md-4 clearfix pull-right">
                        <div class="pull-right"></div>
                    </div>
                </header>
                <div class="panel-body">
                    <div class="adv-table editable-table">
                        <div class="space15"></div>
                        <table class="table table-striped table-hover table-bordered" id="editable-sample1">
                            <thead>
                                <tr>
                                    <th>Id</th>
                                    <th>Patient</th>
                                    <th>Doctor</th>
                                    <th>Date - Time</th>
                                    <th>Remarks</th>
                                    <th>Status</th>
                                    <th>Options</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach (App\DoctorAppoinment::where('appoinment_status','Pending Confirmation')->latest()->get() as $item)
                                    <tr>
                                        <td>{{ $item->id }}</td>
                                        @if ($item->patient)
                                            <td>{{ $item->patient->name }}</td>
                                        @else
                                            <td></td>
                                        @endif
                                        @if ($item->doctor)
                                            <td>{{ $item->doctor->name }}</td>
                                        @else
                                            <td></td>
                                        @endif
                                        <td>{{ $item->appoinment_date }} | {{ $item->appoinment_time }}</td>
                                        <td> {{ $item->remarks }}</td>
                                        <td> {{ $item->appoinment_status }}</td>
                                        <td>
                                            <button type="button" class="btn btn-info btn-xs btn_width editbutton" data-toggle="modal" data-id="{{$item->id}}">
                                                <i class="fa fa-chec"> Accept</i>
                                            </button>
                                        </td>
                                    </tr>
                                @endforeach
                                <style>
                                    .img_url {
                                        height: 20px;
                                        width: 20px;
                                        background-size: contain;
                                        max-height: 20px;
                                        border-radius: 100px;
                                    }
                                </style>
                            </tbody>
                        </table>
                    </div>
                </div>
            </section>
            <!-- page end-->
        </section>
    </section>
    <!--main content end-->

    <!-- Edit Event Modal-->
    <div class="modal fade" id="myModal2" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                    <h4 class="modal-title">Accept Appointment</h4>
                </div>
                <div class="modal-body row">
                    <form role="form" id="editAppointmentForm" action="{{ route('accept_doctor_appointment') }}" class="clearfix" method="post" enctype="multipart/form-data">
                        @csrf

                        <div class="col-md-6 panel">
                            <label for="exampleInputEmail1"> Appointment Status</label>
                            <select class="form-control m-bot15" name="appoinment_status" value="">
                                <option value="Confirmed"> Confirmed </option>
                            </select>
                        </div>

                        <input type="hidden" name="id" id="appointment_id" value="" />
                        <div class="col-md-12 panel">
                            <button type="submit" name="submit" class="btn btn-info pull-right">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <!-- Edit Event Modal-->
    <script type="text/javascript">
        $(document).ready(function () {
            $(".table").on("click", ".editbutton", function () {
                // e.preventDefault(e);
                // Get the record's ID via attribute
                var iid = $(this).attr("data-id");
                var id = $(this).attr("data-id");

                $("#editAppointmentForm").trigger("reset");
                $("#myModal2").modal("show");
                $.ajax({
                    url: "/appointment/edit/" + iid,
                    method: "GET",
                    data: "",
                    dataType: "json",
                }).success(function (response) {
                    // console.log(response);
                    var de = response.appoinment_date;
                    var d = new Date(de);
                    var da = d.getFullYear() + "-" + (d.getMonth() + 1) + "-" + d.getDate();
                    console.log(da,de);
                    // Populate the form fields with the data returned from server
                    $("#editAppointmentForm").find('[name="id"]').val(response.id).end();
                    $("#editAppointmentForm").find('[name="patient_id"]').val(response.patient_id).end();
                    $("#editAppointmentForm").find('[name="doctor_id"]').val(response.doctor_id).end();
                    $("#editAppointmentForm").find('[name="appoinment_date"]').val(response.appoinment_date).end();
                    $("#editAppointmentForm").find('[name="status"]').val(response.appoinment_status).end();
                    $("#editAppointmentForm").find('[name="remarks"]').val(response.remarks).end();

                    $('#adoctors1').val(response.doctor_id).trigger('change');
                    $('.patiente').val(response.patient_id).trigger('change');
                    $("#aslots1").append($("<option>").text(response.appoinment_time).val(response.appoinment_time+ '|' + response.start_time + '|' + response.end_time )).end();

                });
            });
        });
    </script>
@endsection
