@extends('layouts.website.website')
@section('content')
    <!--main content start-->
    <section id="main-content">
        <section class="wrapper site-min-height">
            <!-- page start-->
            <section class="panel">
                <header class="panel-heading">
                    Birth Report
                    <div class="col-md-4 no-print pull-right">
                        <a data-toggle="modal" href="#myModal">
                            <div class="btn-group pull-right">
                                <button id="" class="btn green btn-xs"><i class="fa fa-plus-circle"></i> Add New Report</button>
                            </div>
                        </a>
                    </div>
                </header>
                <div class="panel-body">
                    <div class="adv-table editable-table">
                        <div class="space15"></div>
                        <table class="table table-striped table-hover table-bordered" id="editable-sample">
                            <thead>
                                <tr>
                                    <th>Patient</th>
                                    <th>Description</th>
                                    <th>Doctor</th>
                                    <th>Date</th>
                                    <th class="no-print">Options</th>
                                </tr>
                            </thead>
                            <tbody>
                                <style>
                                    .img_url {
                                        height: 20px;
                                        width: 20px;
                                        background-size: contain;
                                        max-height: 20px;
                                        border-radius: 100px;
                                    }
                                </style>

                                @foreach ($reports as $item)
                                    <tr class="">
                                        <td>{{ $item->patient->name }}</td>
                                        <td>{{ $item->description }}</td>
                                        <td>{{ $item->doctor->name }}</td>
                                        <td class="center">{{ Carbon\Carbon::parse($item->date)->format('d,M Y') }}</td>
                                        <td class="no-print">
                                            <button type="button" class="btn btn-info btn-xs btn_width editbutton" title="Edit" data-toggle="modal" data-id="{{ $item->id }}"><i class="fa fa-edit"></i></button>
                                            <a class="btn btn-info btn-xs btn_width delete_button" title="Delete" href="{{ route('delete_report',$item->id) }}" onclick="return confirm('Are you sure you want to delete this item?');"><i class="fa fa-trash"></i> </a>
                                        </td>
                                    </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </section>
            <!-- page end-->
        </section>
    </section>
    <!--main content end-->
    <!--footer start-->

    <!-- Add Birth Report Modal-->
    <div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                    <h4 class="modal-title">Add New Report</h4>
                </div>
                <div class="modal-body">
                    <form role="form" action="{{ route('store_report') }}" class="clearfix" method="post" enctype="multipart/form-data">
                        @csrf
                        <div class="form-group">
                            <label for="exampleInputEmail1">Select Type</label>
                            <select class="form-control m-bot15" name="type" value="">
                                <option value="birth" selected>Birth</option>
                                <option value="operation">Operation</option>
                                <option value="expire">Expire</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="exampleInputEmail1">Description</label>
                            <input type="text" class="form-control" name="description" id="exampleInputEmail1" value="" placeholder="" />
                        </div>
                        <div class="form-group">
                            <label for="exampleInputEmail1">Patient</label>
                            <select class="form-control m-bot15 pos_select" id="pos_select" name="patient" value="">
                                <option value="">Choose</option>
                                @foreach (App\User::where('role_id',8)->orderBy('name','ASC')->get() as $item)
                                    <option value="{{ $item->id }}">{{ $item->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="exampleInputEmail1">Doctor</label>
                            <select class="form-control m-bot15 add_doctor" id="add_doctor" name="doctor" value="">
                                @foreach (App\User::where('role_id',4)->orderBy('name','ASC')->get() as $item)
                                    <option value="{{ $item->id }}">{{ $item->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="exampleInputEmail1">Date</label>
                            <input class="form-control form-control-inline input-medium" name="date" size="16" type="date" value="" />
                        </div>
                        <input type="hidden" name="id" value="" />
                        <div class="">
                            <button type="submit" name="submit" class="btn btn-info pull-right">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <!-- Add Birth Report Modal-->

    <!-- Edit Birth Report Modal-->
    <div class="modal fade" id="myModal2" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                    <h4 class="modal-title">Edit Birth Report</h4>
                </div>
                <div class="modal-body">
                    <form role="form" id="editReportForm" class="clearfix" action="{{ route('update_report') }}" method="post" enctype="multipart/form-data">
                        @csrf
                        <div class="form-group">
                            <label for="exampleInputEmail1">Select Type</label>
                            <select class="form-control m-bot15" name="type" value="">
                                <option value="birth" selected>Birth</option>
                                <option value="operation">Operation</option>
                                <option value="expire">Expire</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="exampleInputEmail1">Description</label>
                            <input type="text" class="form-control" name="description" id="exampleInputEmail1" value="" placeholder="" />
                        </div>
                        <div class="form-group">
                            <label for="exampleInputEmail1">Patient</label>
                            <select class="form-control m-bot15 add_doctor" id="add_doctor" name="patient" value="">
                                @foreach (App\User::where('role_id',8)->orderBy('name','ASC')->get() as $item)
                                    <option value="{{ $item->id }}">{{ $item->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="exampleInputEmail1">Doctor</label>
                            <select class="form-control m-bot15 add_doctor" id="add_doctor" name="doctor" value="">
                                @foreach (App\User::where('role_id',4)->orderBy('name','ASC')->get() as $item)
                                    <option value="{{ $item->id }}">{{ $item->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="exampleInputEmail1">Date</label>
                            <input class="form-control form-control-inline input-medium default-date-picker" readonly="" name="date" size="16" type="text" value="" />
                        </div>
                        <input type="hidden" name="id" value="" />

                        <div class="">
                            <button type="submit" name="submit" class="btn btn-info pull-right">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <!-- Edit Birth Report Modal-->

    <script type="text/javascript">
        $(document).ready(function () {
            $(".editbutton").click(function (e) {
                e.preventDefault(e);
                // Get the record's ID via attribute
                var iid = $(this).attr("data-id");
                $("#editReportForm").trigger("reset");
                $.ajax({
                    url: "/report/edit/" + iid,
                    method: "GET",
                    data: "",
                    dataType: "json",
                }).success(function (response) {
                    // console.log(response);
                    // Populate the form fields with the data returned from server
                    $("#editReportForm").find('[name="id"]').val(response.id).end();
                    $("#editReportForm").find('[name="type"]').val(response.type).end();
                    $("#editReportForm").find('[name="description"]').val(response.description).end();
                    // $("#editReportForm").find('[name="patient"]').val(response.patient).end();
                    // $("#editReportForm").find('[name="doctor"]').val(response.doctor).end();
                    $("#editReportForm").find('[name="date"]').val(response.date).end();
                    $("#editReportForm").find('[name="patient"]').val(response.patient_id).trigger("change");
                    $("#editReportForm").find('[name="doctor"]').val(response.doctor_id).trigger("change");
                    $("#myModal2").modal("show");
                });
            });
        });
    </script>

<script>
    $(document).ready(function () {
        $("#pos_select").select2({
            placeholder: 'Search Patient Name / ID',
            allowClear: true,
            // ajax: {
            //     url: 'patient/getPatientinfoWithAddNewOption',
            //     type: "post",
            //     dataType: 'json',
            //     delay: 250,
            //     data: function (params) {
            //         return {
            //             searchTerm: params.term // search term
            //         };
            //     },
            //     processResults: function (response) {
            //         return {
            //             results: response
            //         };
            //     },
            //     cache: true
            // }

        });

        $(".add_doctor").select2({
            placeholder: 'Search Doctor Name / ID',
            allowClear: true,
            // ajax: {
            //     url: 'doctor/getDoctorWithAddNewOption',
            //     type: "post",
            //     dataType: 'json',
            //     delay: 250,
            //     data: function (params) {
            //         return {
            //             searchTerm: params.term // search term
            //         };
            //     },
            //     processResults: function (response) {
            //         return {
            //             results: response
            //         };
            //     },
            //     cache: true
            // }

        });

    });
</script>

@endsection
