@extends('layouts.website.website')
@section('content')

    <!--main content start-->
    <section id="main-content">
        <section class="wrapper site-min-height">
            <!-- page start-->
            <section class="panel">
                <header class="panel-heading">
                    Prescription
                    <div class="col-md-4 no-print pull-right">
                        @if (Auth::user()->role_id == 4)
                            <a href="/prescription/add">
                                <div class="btn-group pull-right">
                                    <button id="" class="btn green btn-xs"><i class="fa fa-plus-circle"></i> Add New</button>
                                </div>
                            </a>
                        @endif
                    </div>
                </header>
                <div class="panel-body">
                    <div class="adv-table editable-table">
                        <div class="space15"></div>
                        <table class="table table-striped table-hover table-bordered" id="editable-sample">
                            <thead>
                                <tr>
                                    <th>Prescription Id</th>
                                    <th>Date</th>
                                    <th>Patient</th>
                                    <th>Patient Id</th>
                                    <th>Medicine</th>
                                    <th>Options</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($prescription as $item)
                                    @if($item->patient)
                                        <tr role="row" class="odd">
                                            <td class="sorting_1 dtr-control">{{ $item->id }}</td>
                                            <td>{{ Carbon\Carbon::parse($item->date)->format('d,M Y h:i') }}</td>
                                            <td>{{ $item->patient->name }}</td>
                                            <td>{{ $item->patient_id }}</td>
                                            <td>
                                                <p>
                                                    @foreach (App\DoctorPrescriptionMedicine::where('prescription_id',$item->id)->get() as $med)
                                                        {{ $med->medicine }} - {{ $med->dosage }}mg | {{ $med->frequency }}<br />
                                                    @endforeach
                                                </p>
                                            </td>
                                            <td>
                                                <a class="btn btn-info btn-xs btn_width" href="{{ route('website_prescription_view',$item->id) }}"><i class="fa fa-eye">View Prescription </i></a>
                                                {{-- <a class="btn btn-info btn-xs btn_width" href="prescription/editPrescription?id=107" data-id="107"><i class="fa fa-edit"></i> Edit Prescription</a> --}}
                                                @if (Auth::user()->role_id == 4)
                                                    <a class="btn btn-info btn-xs btn_width delete_button" href="prescription/delete?id=107" onclick="return confirm('Are you sure you want to delete this item?');"><i class="fa fa-trash"> </i></a>
                                                @endif
                                                {{-- <a class="btn btn-info btn-xs invoicebutton" title="Print" style="color: #fff;" href="prescription/viewPrescriptionPrint?id=107" target="_blank"> <i class="fa fa-print"></i> Print</a> --}}
                                            </td>
                                        </tr>
                                    @endif
                                @endforeach


                                <style>
                                    .img_url {
                                        height: 20px;
                                        width: 20px;
                                        background-size: contain;
                                        max-height: 20px;
                                        border-radius: 100px;
                                    }
                                </style>
                            </tbody>
                        </table>
                    </div>
                </div>
            </section>
            <!-- page end-->
        </section>
    </section>
    <!--main content end-->
    <!--footer start-->

    @if (Auth::user()->role_id == 4)
        <!-- Add Prescription Modal-->
        <div class="modal fade" id="myModa3" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                        <h4 class="modal-title"><i class="fa fa-plus-circle"></i> Add Prescription</h4>
                    </div>
                    <div class="modal-body">
                        <form role="form" action="prescription/addNewPrescription" method="post" enctype="multipart/form-data">
                            <div class="form-group col-md-12">
                                <input type="hidden" class="form-control form-control-inline input-medium default-date-picker" name="doctor" id="exampleInputEmail1" value="147" placeholder="" />
                            </div>
                            <div class="form-group col-md-6">
                                <label for="exampleInputEmail1">Date</label>
                                <input type="text" class="form-control form-control-inline input-medium default-date-picker" name="date" id="exampleInputEmail1" value="" placeholder="" />
                            </div>
                            <div class="form-group col-md-6">
                                <label for="exampleInputEmail1">Patient</label>
                                <select class="form-control m-bot15 js-example-basic-single" name="patient" value="">
                                    <option value="">Select .....</option>
                                    <option value="80">pacient </option>
                                    <option value="79">Samba Fall </option>
                                    <option value="78">adfa </option>
                                    <option value="77">Alex Jones </option>
                                    <option value="76">Vinoth kumar </option>
                                    <option value="75">Niyamathullah </option>
                                    <option value="74">Niyamathullah </option>
                                    <option value="73">Habib </option>
                                    <option value="72">Rani </option>
                                    <option value="71">abhishk </option>
                                    <option value="70">g </option>
                                    <option value="69">Muted Faith </option>
                                    <option value="68">Muted Faith </option>
                                    <option value="66">indrasen </option>
                                    <option value="65">usmansiddique406@gmail.com </option>
                                    <option value="64">محمد السيد </option>
                                    <option value="63">name </option>
                                    <option value="62">Mr Patient </option>
                                    <option value="61">Amadou Diop </option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-md-3">History</label>
                                <div class="col-md-9">
                                    <textarea class="ckeditor form-control" name="symptom" value="" rows="10"></textarea>
                                </div>
                            </div>

                            <div class="form-group">
                                <label class="control-label col-md-3">Medication</label>
                                <div class="col-md-9">
                                    <textarea class="ckeditor form-control" name="medicine" value="" rows="10"></textarea>
                                </div>
                            </div>

                            <div class="form-group">
                                <label class="control-label col-md-3">Note</label>
                                <div class="col-md-9">
                                    <textarea class="ckeditor form-control" name="note" value="" rows="10"></textarea>
                                </div>
                            </div>

                            <input type="hidden" name="patient_id" value="" />
                            <input type="hidden" name="id" value="" />
                            <section class="">
                                <button type="submit" name="submit" class="btn btn-info submit_button">Submit</button>
                            </section>
                        </form>
                    </div>
                </div>
                <!-- /.modal-content -->
            </div>
            <!-- /.modal-dialog -->
        </div>
        <!-- Add Prescription Modal-->

        <!-- Edit Prescription Modal-->
        <div class="modal fade" id="myModal5" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                        <h4 class="modal-title"><i class="fa fa-plus-circle"></i> Edit Prescription</h4>
                    </div>
                    <div class="modal-body">
                        <form role="form" id="prescriptionEditForm" action="prescription/addNewPrescription" method="post" enctype="multipart/form-data">
                            <div class="form-group col-md-12">
                                <input type="hidden" class="form-control form-control-inline input-medium default-date-picker" name="doctor" id="exampleInputEmail1" value="" placeholder="" />
                            </div>
                            <div class="form-group col-md-6">
                                <label for="exampleInputEmail1">Date</label>
                                <input type="text" class="form-control form-control-inline input-medium default-date-picker" name="date" id="exampleInputEmail1" value="" placeholder="" />
                            </div>
                            <div class="form-group col-md-6">
                                <label for="exampleInputEmail1">Patient</label>
                                <select class="form-control m-bot15" name="patient" value="">
                                    <option value="">Select .....</option>
                                    <option value="80">pacient </option>
                                    <option value="79">Samba Fall </option>
                                    <option value="78">adfa </option>
                                    <option value="77">Alex Jones </option>
                                    <option value="76">Vinoth kumar </option>
                                    <option value="75">Niyamathullah </option>
                                    <option value="74">Niyamathullah </option>
                                    <option value="73">Habib </option>
                                    <option value="72">Rani </option>
                                    <option value="71">abhishk </option>
                                    <option value="70">g </option>
                                    <option value="69">Muted Faith </option>
                                    <option value="68">Muted Faith </option>
                                    <option value="66">indrasen </option>
                                    <option value="65">usmansiddique406@gmail.com </option>
                                    <option value="64">محمد السيد </option>
                                    <option value="63">name </option>
                                    <option value="62">Mr Patient </option>
                                    <option value="61">Amadou Diop </option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-md-3">History</label>
                                <div class="col-md-9">
                                    <textarea class="ckeditor form-control" id="editor1" name="symptom" value="" rows="10"></textarea>
                                </div>
                            </div>

                            <div class="form-group">
                                <label class="control-label col-md-3">Medication</label>
                                <div class="col-md-9">
                                    <textarea class="ckeditor form-control" id="editor2" name="medicine" value="" rows="10"></textarea>
                                </div>
                            </div>

                            <div class="form-group">
                                <label class="control-label col-md-3">Note</label>
                                <div class="col-md-9">
                                    <textarea class="ckeditor form-control" id="editor3" name="note" value="" rows="10"></textarea>
                                </div>
                            </div>

                            <input type="hidden" name="id" value="" />
                            <section class="">
                                <button type="submit" name="submit" class="btn btn-info submit_button">Submit</button>
                            </section>
                        </form>
                    </div>
                </div>
                <!-- /.modal-content -->
            </div>
            <!-- /.modal-dialog -->
        </div>
        <!-- Edit Prescription Modal-->
    @endif
    <script src="common/js/codearistos.min.js"></script>

    <script type="text/javascript">
        $(document).ready(function () {
            $(".table").on("click", ".editPrescription", function () {
                //   e.preventDefault(e);
                // Get the record's ID via attribute
                var iid = $(this).attr("data-id");
                $("#myModal5").modal("show");
                $.ajax({
                    url: "prescription/editPrescriptionByJason?id=" + iid,
                    method: "GET",
                    data: "",
                    dataType: "json",
                }).success(function (response) {
                    var de = response.prescription.date * 1000;
                    var d = new Date(de);
                    var da = d.getDate() + 1 + "-" + (d.getMonth() + 1) + "-" + d.getFullYear();
                    // Populate the form fields with the data returned from server
                    $("#prescriptionEditForm").find('[name="id"]').val(response.prescription.id).end();
                    $("#prescriptionEditForm").find('[name="date"]').val(da).end();
                    // Populate the form fields with the data returned from server
                    $("#prescriptionEditForm").find('[name="patient"]').val(response.prescription.patient).end();
                    $("#prescriptionEditForm").find('[name="doctor"]').val(response.prescription.doctor).end();

                    CKEDITOR.instances["editor1"].setData(response.prescription.symptom);
                    CKEDITOR.instances["editor2"].setData(response.prescription.medicine);
                    CKEDITOR.instances["editor3"].setData(response.prescription.note);
                });
            });
        });
    </script>


@endsection
