@extends('layouts.website.website') @section('content')

<section id="main-content">
    <section class="wrapper site-min-height">
        <!-- page start-->
        <section class="">
            <header class="panel-heading">
                Patient Database
                <div class="col-md-4 no-print pull-right">
                    <a data-toggle="modal" href="#myModal">
                        <div class="btn-group pull-right">
                            <button id="" class="btn green btn-xs"><i class="fa fa-plus-circle"></i> Add New</button>
                        </div>
                    </a>
                </div>
            </header>
            <div class="panel-body">
                <div class="adv-table editable-table">
                    <div class="space15"></div>
                    <table class="table table-striped table-hover table-bordered" id="editable-sample">
                        <thead>
                            <tr>
                                <th>Patient ID</th>
                                <th>Name</th>
                                <th>Doctor</th>
                                <th>Phone</th>
                                <th>Due Balance</th>
                                <th class="no-print">Options</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach (App\User::where('role_id',8)->orderBy('name','ASC')->get() as $item)
                                <tr role="row">
                                    <td class="sorting_1 dtr-control">{{ $item->id }}</td>
                                    <td>{{ $item->name }} </td>
                                    @if ($item->patients_doctor)
                                        <td>{{ $item->patients_doctor->name }} </td>
                                    @else
                                        <td></td>
                                    @endif
                                    <td>{{ $item->phone }}</td>
                                    <td></td>
                                    <td>
                                        <a type="button" class="btn editbutton" title="Edit" data-toggle="modal" data-id="{{ $item->id }}">
                                            <i class="fa fa-edit"></i> Edit
                                        </a>
                                        <a type="button" class="btn detailsbutton inffo" title="Info" data-toggle="modal" data-id="{{ $item->id }}">
                                            <i class="fa fa-info"></i> Info
                                        </a>
                                        <a class="btn green" title="History" style="color: #fff;" href="/patient/medicalHistory?patientid={{ $item->id }}">
                                            <i class="fa fa-stethoscope"></i> History
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                            <style>
                                .img_url {
                                    height: 20px;
                                    width: 20px;
                                    background-size: contain;
                                    max-height: 20px;
                                    border-radius: 100px;
                                }
                            </style>
                        </tbody>
                    </table>
                </div>
            </div>
        </section>
        <!-- page end-->
    </section>
</section>
<!--main content end-->
<!--footer start-->

<!-- Add Patient Modal-->
<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title">Register Patient</h4>
            </div>
            <div class="modal-body row">
                <form role="form" action="{{ route('store_patient') }}" class="clearfix" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="form-group col-md-6">
                        <label for="exampleInputEmail1">Name</label>
                        <input type="text" class="form-control" name="name" id="exampleInputEmail1" value="" placeholder="" />
                    </div>

                    <div class="form-group col-md-6">
                        <label for="exampleInputEmail1">Email</label>
                        <input type="text" class="form-control" name="email" id="exampleInputEmail1" value="" placeholder="" />
                    </div>

                    <div class="form-group col-md-6">
                        <label for="exampleInputEmail1">Password</label>
                        <input type="password" class="form-control" name="password" id="exampleInputEmail1" placeholder="" />
                    </div>

                    <div class="form-group col-md-6">
                        <label for="exampleInputEmail1">Address</label>
                        <input type="text" class="form-control" name="address" id="exampleInputEmail1" value="" placeholder="" />
                    </div>
                    <div class="form-group col-md-6">
                        <label for="exampleInputEmail1">Phone</label>
                        <input type="text" class="form-control" name="phone" id="exampleInputEmail1" value="" placeholder="" />
                    </div>
                    <div class="form-group col-md-6">
                        <label for="exampleInputEmail1">Sex</label>
                        <select class="form-control m-bot15" name="sex" value="">
                            <option value="Male"> Male </option>
                            <option value="Female"> Female </option>
                            <option value="Others"> Others </option>
                        </select>
                    </div>

                    <div class="form-group col-md-6">
                        <label>Birth Date</label>
                        <input class="form-control form-control-inline input-medium default-date-picker" type="text" name="birthdate" value="" placeholder="" readonly="" />
                    </div>

                    <div class="form-group col-md-6">
                        <label for="exampleInputEmail1">Blood Group</label>
                        <select class="form-control m-bot15" name="bloodgroup" value="">
                            <option value="A+"> A+ </option>
                            <option value="A-"> A- </option>
                            <option value="B+"> B+ </option>
                            <option value="B-"> B- </option>
                            <option value="AB+"> AB+ </option>
                            <option value="AB-"> AB- </option>
                            <option value="O+"> O+ </option>
                            <option value="O-"> O- </option>
                        </select>
                    </div>

                    <div class="form-group col-md-6">
                        <label for="exampleInputEmail1">Doctor</label>
                        <select class="form-control m-bot15" id="doctorchoose1" name="doctor" value="">
                            @foreach (App\User::where('role_id',4)->orderBy('name','ASC')->get() as $doc)
                                <option value="{{ $doc->id }}">{{ $doc->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group last col-md-6">
                        <label class="control-label">Image Upload</label>
                        <div class="">
                            <div class="fileupload fileupload-new" data-provides="fileupload">
                                <div class="fileupload-new thumbnail" style="width: 200px; height: 150px;">
                                    <img src="//www.placehold.it/200x150/EFEFEF/AAAAAA&amp;text=no+image" alt="" />
                                </div>
                                <div class="fileupload-preview fileupload-exists thumbnail" style="max-width: 200px; max-height: 150px; line-height: 20px;"></div>
                                <div>
                                    <span class="btn btn-white btn-file">
                                        <span class="fileupload-new"><i class="fa fa-paper-clip"></i> Select image</span>
                                        <span class="fileupload-exists"><i class="fa fa-undo"></i> Change</span>
                                        <input type="file" class="default" name="img_url" />
                                    </span>
                                    <a href="#" class="btn btn-danger fileupload-exists" data-dismiss="fileupload"><i class="fa fa-trash"></i> Remove</a>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!--
                                        <div class="form-group last col-md-6">
                                            <div style="text-align:center;" class="col-md-12">
                                                <video id="video" width="200" height="200" autoplay></video>
                                                <div class="snap" id="snap">Capture Photo</div>
                                                <canvas id="canvas" width="200" height="200"></canvas>
                                                Right click on the captured image and save. Then select the saved image from the left side's Select Image button.
                                            </div>
                                        </div>
                    -->

                    <div class="form-group col-md-6"><input type="checkbox" name="sms" value="sms" /> Send SMS<br /></div>

                    <section class="col-md-12">
                        <button type="submit" name="submit" class="btn btn-info pull-right">Submit</button>
                    </section>
                </form>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- Add Patient Modal-->

<!-- Edit Patient Modal-->
<div class="modal fade" id="myModal2" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title">Edit Patient</h4>
            </div>
            <div class="modal-body row">
                <form role="form" id="editPatientForm" action="{{ route('update_patient') }}" class="clearfix" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="form-group col-md-6">
                        <label for="exampleInputEmail1">Name</label>
                        <input type="text" class="form-control" name="name" id="exampleInputEmail1" value="" placeholder="" />
                    </div>

                    <div class="form-group col-md-6">
                        <label for="exampleInputEmail1">Email</label>
                        <input type="text" class="form-control" name="email" id="exampleInputEmail1" value="" placeholder="" />
                    </div>

                    <div class="form-group col-md-6">
                        <label for="exampleInputEmail1">Password</label>
                        <input type="password" class="form-control" name="password" id="exampleInputEmail1" placeholder="" />
                    </div>

                    <div class="form-group col-md-6">
                        <label for="exampleInputEmail1">Address</label>
                        <input type="text" class="form-control" name="address" id="exampleInputEmail1" value="" placeholder="" />
                    </div>
                    <div class="form-group col-md-6">
                        <label for="exampleInputEmail1">Phone</label>
                        <input type="text" class="form-control" name="phone" id="exampleInputEmail1" value="" placeholder="" />
                    </div>
                    <div class="form-group col-md-6">
                        <label for="exampleInputEmail1">Sex</label>
                        <select class="form-control m-bot15" name="sex" value="">
                            <option value="Male"> Male </option>
                            <option value="Female"> Female </option>
                            <option value="Others"> Others </option>
                        </select>
                    </div>

                    <div class="form-group col-md-6">
                        <label>Birth Date</label>
                        <input class="form-control form-control-inline input-medium default-date-picker" type="text" name="birthdate" value="" placeholder="" readonly="" />
                    </div>

                    <div class="form-group col-md-6">
                        <label for="exampleInputEmail1">Blood Group</label>
                        <select class="form-control m-bot15" name="bloodgroup" value="">
                            <option value="A+"> A+ </option>
                            <option value="A-"> A- </option>
                            <option value="B+"> B+ </option>
                            <option value="B-"> B- </option>
                            <option value="AB+"> AB+ </option>
                            <option value="AB-"> AB- </option>
                            <option value="O+"> O+ </option>
                            <option value="O-"> O- </option>
                        </select>
                    </div>

                    <div class="form-group col-md-6">
                        <label for="exampleInputEmail1">Doctor</label>
                        <select class="form-control m-bot15" id="doctorchoose" name="doctor" value="">
                            @foreach (App\User::where('role_id',4)->orderBy('name','ASC')->get() as $doc)
                                <option value="{{ $doc->id }}">{{ $doc->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group last col-md-6">
                        <label class="control-label">Image Upload</label>
                        <div class="">
                            <div class="fileupload fileupload-new" data-provides="fileupload">
                                <div class="fileupload-new thumbnail" style="width: 200px; height: 150px;">
                                    <img src="//www.placehold.it/200x150/EFEFEF/AAAAAA&amp;text=no+image" id="img" alt="" />
                                </div>
                                <div class="fileupload-preview fileupload-exists thumbnail" style="max-width: 200px; max-height: 150px; line-height: 20px;"></div>
                                <div>
                                    <span class="btn btn-white btn-file">
                                        <span class="fileupload-new"><i class="fa fa-paper-clip"></i> Select image</span>
                                        <span class="fileupload-exists"><i class="fa fa-undo"></i> Change</span>
                                        <input type="file" class="default" name="img_url" />
                                    </span>
                                    <a href="#" class="btn btn-danger fileupload-exists" data-dismiss="fileupload"><i class="fa fa-trash"></i> Remove</a>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!--

                    <div class="form-group last col-md-6">
                        <div style="text-align:center;">
                            <video id="video" width="200" height="200" autoplay></video>
                            <div class="snap" id="snap">Capture Photo</div>
                            <canvas id="canvas" width="200" height="200"></canvas>
                            Right click on the captured image and save. Then select the saved image from the left side's Select Image button.
                        </div>
                    </div>

                    -->

                    <div class="form-group col-md-6"><input type="checkbox" name="sms" value="sms" /> Send SMS<br /></div>

                    <input type="hidden" name="id" value="" />
                    <input type="hidden" name="p_id" value="" />

                    <section class="col-md-12">
                        <button type="submit" name="submit" class="btn btn-info pull-right">Submit</button>
                    </section>
                </form>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
</div>
<!-- Edit Patient Modal-->

<div class="modal fade" id="infoModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title">Patient Info</h4>
            </div>
            <div class="modal-body row">
                <form role="form" id="editPatientForm" action="patient/addNew" class="clearfix" method="post" enctype="multipart/form-data">
                    <div class="form-group last col-md-4">
                        <div class="">
                            <div class="fileupload fileupload-new" data-provides="fileupload">
                                <div class="fileupload-new thumbnail" style="width: 200px; height: 150px;">
                                    <img src="//www.placehold.it/200x150/EFEFEF/AAAAAA&amp;text=no+image" id="img1" alt="" />
                                </div>
                                <div class="fileupload-preview fileupload-exists thumbnail" style="max-width: 200px; max-height: 150px; line-height: 20px;"></div>
                            </div>
                            <div class="col-md-12">
                                <label for="exampleInputEmail1">Patient ID: <span class="patientIdClass"></span></label>
                            </div>
                        </div>
                    </div>
                    <div class="form-group col-md-4">
                        <label for="exampleInputEmail1">Name</label>
                        <div class="nameClass"></div>
                    </div>

                    <div class="form-group col-md-4">
                        <label for="exampleInputEmail1">Email</label>
                        <div class="emailClass"></div>
                    </div>

                    <div class="form-group col-md-4">
                        <label>Age</label>
                        <div class="ageClass"></div>
                    </div>

                    <div class="form-group col-md-4">
                        <label for="exampleInputEmail1">Address</label>
                        <div class="addressClass"></div>
                    </div>

                    <div class="form-group col-md-4">
                        <label for="exampleInputEmail1">Gender</label>
                        <div class="genderClass"></div>
                    </div>

                    <div class="form-group col-md-4">
                        <label for="exampleInputEmail1">Phone</label>
                        <div class="phoneClass"></div>
                    </div>

                    <div class="form-group col-md-4">
                        <label for="exampleInputEmail1">Blood Group</label>
                        <div class="bloodgroupClass"></div>
                    </div>

                    <div class="form-group col-md-4">
                        <label>Birth Date</label>
                        <div class="birthdateClass"></div>
                    </div>

                    <div class="form-group col-md-4"></div>
                    <div class="form-group col-md-4"></div>
                    <div class="form-group col-md-4">
                        <label for="exampleInputEmail1">Doctor</label>
                        <div class="doctorClass"></div>
                    </div>
                </form>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
</div>


<style>
    .wrapper {
        padding: 0px 12px 0px 15px !important;
    }
</style>

<script type="text/javascript">
    $(".table").on("click", ".editbutton", function () {
        //    e.preventDefault(e);
        // Get the record's ID via attribute
        var iid = $(this).attr("data-id");
        $("#img").attr("src", "/uploads/cardiology-patient-icon-vector-6244713.jpg");
        $("#editPatientForm").trigger("reset");
        $.ajax({
            url: "/patient/edit/" + iid,
            method: "GET",
            data: "",
            dataType: "json",
        }).success(function (response) {
            // console.log(response);
            // Populate the form fields with the data returned from server

            $("#editPatientForm").find('[name="id"]').val(response.id).end();
            $("#editPatientForm").find('[name="name"]').val(response.name).end();
            $("#editPatientForm").find('[name="password"]').val(response.password).end();
            $("#editPatientForm").find('[name="email"]').val(response.email).end();
            $("#editPatientForm").find('[name="address"]').val(response.address).end();
            $("#editPatientForm").find('[name="phone"]').val(response.phone).end();
            $("#editPatientForm").find('[name="sex"]').val(response.sex).end();
            $("#editPatientForm").find('[name="birthdate"]').val(response.birth_date).end();
            $("#editPatientForm").find('[name="bloodgroup"]').val(response.blood_group).end();
            $("#editPatientForm").find('[name="p_id"]').val(response.id).end();

            if (typeof response.photo !== "undefined" && response.photo != "") {
                $("#img").attr("src", "/"+response.photo);
            }

            // if (response.doctor !== null) {
            //     var option1 = new Option(response.patient_doctor + "-" + response.patient_doctor, response.patient_doctor, true, true);
            // } else {
            //     var option1 = new Option(" " + "-" + "", "", true, true);
            // }
            // $("#editPatientForm").find('[name="doctor"]').append(option1).trigger("change");

            $(".js-example-basic-single.doctor").val(response.patient_doctor).trigger("change");

            $("#myModal2").modal("show");
        });
    });
</script>

<script type="text/javascript">
    $(".table").on("click", ".inffo", function () {
        //    e.preventDefault(e);
        // Get the record's ID via attribute
        var iid = $(this).attr("data-id");

        $("#img1").attr("src", "/uploads/cardiology-patient-icon-vector-6244713.jpg");
        $(".patientIdClass").html("").end();
        $(".nameClass").html("").end();
        $(".emailClass").html("").end();
        $(".addressClass").html("").end();
        $(".phoneClass").html("").end();
        $(".genderClass").html("").end();
        $(".birthdateClass").html("").end();
        $(".bloodgroupClass").html("").end();
        $(".patientidClass").html("").end();
        $(".doctorClass").html("").end();
        $(".ageClass").html("").end();
        $.ajax({
            url: "/patient/edit/" + iid,
            method: "GET",
            data: "",
            dataType: "json",
        }).success(function (response) {
            // Populate the form fields with the data returned from server

            $(".patientIdClass").append(response.id).end();
            $(".nameClass").append(response.name).end();
            $(".emailClass").append(response.email).end();
            $(".addressClass").append(response.address).end();
            $(".phoneClass").append(response.phone).end();
            $(".genderClass").append(response.sex).end();
            $(".birthdateClass").append(response.birth_date).end();
            $(".ageClass").append(response.age).end();
            $(".bloodgroupClass").append(response.blood_group).end();
            $(".patientidClass").append(response.patient_id).end();

            if (response.doctor !== null) {
                $(".doctorClass").append(response.doctor_department).end();
            } else {
                $(".doctorClass").append("").end();
            }

            if (typeof response.img_url !== "undefined" && response.img_url != "") {
                $("#img1").attr("src", '/'+response.img_url);
            }

            $("#infoModal").modal("show");
        });
    });
</script>


<script>
    $(document).ready(function () {
        $("#doctorchoose").select2({
            placeholder: "Search Doctor Name / ID",
            allowClear: true,
            // ajax: {
            //     url: "doctor/getDoctorinfo",
            //     type: "post",
            //     dataType: "json",
            //     delay: 250,
            //     data: function (params) {
            //         return {
            //             searchTerm: params.term, // search term
            //         };
            //     },
            //     processResults: function (response) {
            //         return {
            //             results: response,
            //         };
            //     },
            //     cache: true,
            // },
        });
        $("#doctorchoose1").select2({
            placeholder: "Search Doctor Name / ID",
            allowClear: true,
            // ajax: {
            //     url: "doctor/getDoctorInfo",
            //     type: "post",
            //     dataType: "json",
            //     delay: 250,
            //     data: function (params) {
            //         return {
            //             searchTerm: params.term, // search term
            //         };
            //     },
            //     processResults: function (response) {
            //         return {
            //             results: response,
            //         };
            //     },
            //     cache: true,
            // },
        });
    });
</script>



@endsection
