@extends('layouts.website.website')
@section('content')
    <!--main content start-->
<section id="main-content">
    <section class="wrapper site-min-height">
        <!-- page start-->
        <section class="col-md-3">
            <header class="panel-heading clearfix">
                <div class="">
                    Patient Info
                </div>
            </header>

            <aside class="profile-nav">
                <section class="">
                    <div class="user-heading round">
                        <a href="#">
                            <img src="{{ asset(''.$patient->photo) }}" alt="{{ asset(''.$patient->photo) }}" />
                        </a>
                        <h1>{{ $patient->name }}</h1>
                        <p>{{ $patient->email }}</p>
                    </div>

                    <ul class="nav nav-pills nav-stacked">
                        <!--  <li class="active"> Patient Name<span class="label pull-right r-activity">Mr Patient</span></li> -->
                        <li>Patient ID <span class="label pull-right r-activity">{{ $patient->id }}</span></li>
                        <li>Gender<span class="label pull-right r-activity">{{ $patient->sex }}</span></li>
                        <li>Birth Date<span class="label pull-right r-activity">{{ Carbon\Carbon::parse($patient->birth_date)->format('d,M Y') }}</span></li>
                        <li>Phone<span class="label pull-right r-activity">{{ $patient->phone }}</span></li>
                        <li>Email<span class="label pull-right r-activity">{{ $patient->email }}</span></li>
                        <li style="height: 200px;">Address<span class="pull-right" style="height: 200px;">{{ $patient->address }}</span></li>
                    </ul>
                </section>
            </aside>
        </section>

        <section class="col-md-9">
            <header class="panel-heading clearfix">
                <div class="col-md-7">
                    History | {{ $patient->name }}
                </div>
            </header>

            <section class="panel-body">
                <header class="panel-heading tab-bg-dark-navy-blueee">
                    <ul class="nav nav-tabs">
                        <li class="active">
                            <a data-toggle="tab" href="#appointments">Appointments</a>
                        </li>
                        <li class="">
                            <a data-toggle="tab" href="#home">Case History</a>
                        </li>
                        <li class="">
                            <a data-toggle="tab" href="#about">Prescription</a>
                        </li>
                        <li class="">
                            <a data-toggle="tab" href="#lab">Lab</a>
                        </li>
                        <li class="">
                            <a data-toggle="tab" href="#profile">Documents</a>
                        </li>
                        <li class="">
                            <a data-toggle="tab" href="#contact">Bed</a>
                        </li>
                        <li class="">
                            <a data-toggle="tab" href="#timeline">Timeline</a>
                        </li>
                    </ul>
                </header>
                <div class="panel">
                    <div class="tab-content">
                        <div id="appointments" class="tab-pane active">
                            <div class="">
                                <div class="no-print">
                                    {{-- <a class="btn btn-info btn_width btn-xs" data-toggle="modal" href="#addAppointmentModal"> <i class="fa fa-plus-circle"> </i> Request a Appointment </a> --}}
                                </div>
                                <div class="adv-table editable-table">
                                    <table class="table table-striped table-hover table-bordered" id="">
                                        <thead>
                                            <tr>
                                                <th>Date</th>
                                                <th>Time Slot</th>
                                                <th>Doctor</th>
                                                <th>Status</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach (App\DoctorAppoinment::where('patient_id',$patient->id)->latest()->get() as $item)
                                                <tr>
                                                    <td>{{ $item->appoinment_date }}</td>
                                                    <td>{{ $item->appoinment_time }}</td>
                                                    @if ($item->doctor)
                                                        <td>{{ $item->doctor->name }}</td>
                                                    @else
                                                        <td></td>
                                                    @endif
                                                    <td> {{ $item->appoinment_status }}</td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div id="home" class="tab-pane">
                            <div class="">
                                <div class="adv-table editable-table">
                                    <table class="table table-striped table-hover table-bordered" id="">
                                        <thead>
                                            <tr>
                                                <th>Date</th>
                                                <th>Title</th>
                                                <th>Description</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach (App\PatientCase::where('patient_id',$patient->id)->get() as $item)
                                                <tr>
                                                    <th>{{ $item->date }}</th>
                                                    <th>{{ $item->title }}</th>
                                                    <th>{{ $item->case }}</th>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div id="about" class="tab-pane">
                            <div class="">
                                <div class="adv-table editable-table">
                                    <table class="table table-striped table-hover table-bordered" id="">
                                        <thead>
                                            <tr>
                                                <th>Date</th>
                                                <th>Doctor</th>
                                                <th>Medicine</th>
                                                <th class="no-print">Options</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach (App\DoctorPrescription::where('patient_id',$patient->id)->get() as $item)
                                                <tr>
                                                    <td>{{ $item->date }}</td>
                                                    <td>{{ $item->doctor->name }}</td>
                                                    <td>
                                                        <p>
                                                            @foreach (App\DoctorPrescriptionMedicine::where('prescription_id',$item->id)->get() as $med)
                                                                {{ $med->medicine }} - {{ $med->dosage }}mg | {{ $med->frequency }}<br />
                                                            @endforeach
                                                        </p>
                                                    </td>
                                                    <td>
                                                        <a class="btn btn-info btn-xs btn_width" href="{{ route('website_prescription_view',$item->id) }}"><i class="fa fa-eye">View Prescription </i></a>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <div id="lab" class="tab-pane">
                            <div class="">
                                <div class="adv-table editable-table">
                                    <table class="table table-striped table-hover table-bordered" id="">
                                        <thead>
                                            <tr>
                                                <th>Id</th>
                                                <th>Date</th>
                                                <th>Doctor</th>
                                                <th class="no-print">Options</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach (App\DoctorLab::where('patient_id',$patient->id)->get() as $item)
                                                <tr>
                                                    <td>{{ $item->id }}</td>
                                                    <td>{{ Carbon\Carbon::parse($item->date)->format("d,m Y h:i") }}</td>
                                                    <td>{{ $item->doctor->name }}</td>
                                                    <td>
                                                        {{-- <a class="btn btn-info btn-xs editbutton" title="edit" href="lab?id=1939"><i class="fa fa-edit"> </i> </a> --}}
                                                        <a class="btn btn-xs invoicebutton" title="invoice" style="color: #fff;" href="{{ route('website_lab_view',$item->id) }}"><i class="fa fa-file"></i> </a>
                                                        {{-- <a class="btn btn-info btn-xs delete_button" title="حذف" href="{{ route('delete_lab',$item->id) }}" onclick="return confirm('Are you sure you want to delete this item?');"><i class="fa fa-trash"></i></a> --}}
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <div id="profile" class="tab-pane">
                            <div class="">
                                <div class="no-print">
                                    {{-- <a class="btn btn-info btn_width btn-xs" data-toggle="modal" href="#myModal1"> <i class="fa fa-plus-circle"> </i> Add New </a> --}}
                                </div>
                                <div class="adv-table editable-table">
                                    <div class="">
                                        <div class="adv-table editable-table panel-body">
                                            <table class="table table-striped table-hover table-bordered" id="editable-sample">
                                                <thead>
                                                    <tr>
                                                        <th>Date</th>
                                                        <th>Patient</th>
                                                        <th>Description</th>
                                                        <th style="width: 20%;">Document</th>
                                                        <th class="no-print">Options</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach (App\PatientDocument::where('patient_id',$patient->id)->latest()->get() as $item)
                                                        <tr role="row" class="odd">
                                                            <td class="sorting_1 dtr-control">{{ Carbon\Carbon::parse($item->date)->format('d,M Y h:i') }}</td>
                                                            <td>
                                                                @if ($item->patient)
                                                                    {{ $item->patient->name }}
                                                                    <br />
                                                                    {{ $item->patient->address }}
                                                                    <br />
                                                                    {{ $item->patient->phone }}
                                                                    <br />
                                                                @endif
                                                            </td>
                                                            <td>{{ $item->title }}</td>
                                                            <td>
                                                                <a class="example-image-link" href="{{ asset(''.$item->img_url) }}" data-lightbox="example-1" data-title="Radio Oct 2020">
                                                                    <img class="example-image" src="{{ asset(''.$item->img_url) }}" width="100px" height="100px" alt="image-1" />
                                                                </a>
                                                            </td>
                                                            <td>
                                                                <a class="btn btn-info btn-xs" href="{{ asset(''.$item->img_url) }}" download=""> Download </a>
                                                                <a class="btn btn-info btn-xs delete_button" href="{{ route('website_documentDelete',$item->id) }}" onclick="return confirm('You want to delete the item??');"> X </a>
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div id="contact" class="tab-pane">
                            <div class="">
                                <div class="adv-table editable-table">
                                    <table class="table table-striped table-hover table-bordered" id="">
                                        <thead>
                                            <tr>
                                                <th>Bed Id</th>
                                                <th>Alloted Time</th>
                                                <th>Discharge Time</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <style>
                                                .img_url {
                                                    height: 20px;
                                                    width: 20px;
                                                    background-size: contain;
                                                    max-height: 20px;
                                                    border-radius: 100px;
                                                }
                                            </style>

                                            <tr class="">

                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div id="timeline" class="tab-pane">
                            <div class="">
                                <div class="">
                                    <section class="panel">
                                        <header class="panel-heading">
                                            Timeline
                                        </header>
                                        <!--
                                        <div class=" profile-activity" >
                                            <h5 class="pull-right">12 August 2013</h5>
                                            <div class="activity terques">
                                                <span>
                                                    <i class="fa fa-shopping-cart"></i>
                                                </span>
                                                <div class="activity-desk">
                                                    <div class="panel">
                                                        <div class="">
                                                            <div class="arrow"></div>
                                                            <i class=" fa fa-clock-o"></i>
                                                            <h4>10:45 AM</h4>
                                                            <p>Purchased new equipments for zonal office setup and stationaries.</p>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        -->

                                        <div class="panel-body profile-activity">
                                            <h5 class="pull-left"><span class="label pull-right r-activity">Appointment</span></h5>
                                            <h5 class="pull-right">05-10-2020</h5>
                                            <div class="activity terques">
                                                <span>
                                                    <i class="fa fa-stethoscope"></i>
                                                </span>
                                                <div class="activity-desk">
                                                    <div class="panel col-md-6">
                                                        <div class="panel-body">
                                                            <div class="arrow"></div>
                                                            <i class="fa fa-calendar"></i>
                                                            <h4>05-10-2020</h4>
                                                            <p></p>
                                                            <i class="fa fa-user-md"></i>
                                                            <h4>Mr Doctor</h4>
                                                            <p></p>
                                                            <i class="fa fa-clock-o"></i>
                                                            <p>Not Selected -</p>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </section>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </section>
    </section>
    <!-- page end-->
</section>

<!-- Add Patient Material Modal-->
<div class="modal fade" id="myModal1" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title">Add Files</h4>
            </div>
            <div class="modal-body">
                <form role="form" action="patient/addPatientMaterial" class="clearfix row" method="post" enctype="multipart/form-data">
                    <div class="form-group col-md-6">
                        <label for="exampleInputEmail1"> Title</label>
                        <input type="text" class="form-control" name="title" id="exampleInputEmail1" placeholder="" />
                    </div>
                    <div class="form-group col-md-6">
                        <label for="exampleInputEmail1"> File</label>
                        <input type="file" name="img_url" />
                    </div>

                    <input type="hidden" name="patient" value="1" />

                    <div class="form-group col-md-12">
                        <button type="submit" name="submit" class="btn btn-info pull-right">Submit</button>
                    </div>
                </form>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- Add Patient Modal-->

<!-- Add Medical History Modal-->
<div class="modal fade" id="myModal" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title">Add Case</h4>
            </div>
            <div class="modal-body">
                <form role="form" action="patient/addMedicalHistory" class="clearfix row" method="post" enctype="multipart/form-data">
                    <div class="form-group col-md-12">
                        <label for="exampleInputEmail1">Date</label>
                        <input type="text" class="form-control form-control-inline input-medium default-date-picker" name="date" id="exampleInputEmail1" value="" placeholder="" readonly="" />
                    </div>
                    <div class="form-group col-md-12">
                        <label for="exampleInputEmail1">Title</label>
                        <input type="text" class="form-control form-control-inline input-medium" name="title" id="exampleInputEmail1" value="" placeholder="" />
                    </div>
                    <div class="form-group col-md-12">
                        <label class="">Description</label>
                        <div class="">
                            <textarea class="ckeditor form-control" name="description" value="" rows="10"></textarea>
                        </div>
                    </div>

                    <input type="hidden" name="patient_id" value="1" />
                    <input type="hidden" name="id" value="" />
                    <div class="form-group col-md-12">
                        <button type="submit" name="submit" class="btn btn-info submit_button pull-right">Submit</button>
                    </div>
                </form>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>

<!-- Add Medical History Modal-->

<!-- Edit Medical History Modal-->
<div class="modal fade" id="myModal2" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title">Edit Case</h4>
            </div>
            <div class="modal-body">
                <form role="form" id="medical_historyEditForm" class="clearfix row" action="patient/addMedicalHistory" method="post" enctype="multipart/form-data">
                    <div class="form-group col-md-12">
                        <label for="exampleInputEmail1">Date</label>
                        <input type="text" class="form-control form-control-inline input-medium default-date-picker" name="date" id="exampleInputEmail1" value="" placeholder="" readonly="" />
                    </div>
                    <div class="form-group col-md-12">
                        <label for="exampleInputEmail1">Title</label>
                        <input type="text" class="form-control form-control-inline input-medium" name="title" id="exampleInputEmail1" value="" placeholder="" />
                    </div>
                    <div class="form-group col-md-12">
                        <label class="">Description</label>
                        <div class="">
                            <textarea class="ckeditor form-control editor" id="editor" name="description" value="" rows="10"></textarea>
                        </div>
                    </div>
                    <input type="hidden" name="patient_id" value="1" />
                    <input type="hidden" name="id" value="" />
                    <div class="form-group col-md-12">
                        <button type="submit" name="submit" class="btn btn-info submit_button pull-right">Submit</button>
                    </div>
                </form>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>

<!-- Add Appointment Modal-->
<div class="modal fade" id="addAppointmentModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog modal-lg"">
    <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            <h4 class="modal-title">Add Appointment</h4>
        </div>
        <div class="modal-body">
            <form role="form" action="appointment/addNew" class="clearfix row" method="post" enctype="multipart/form-data">
                <div class="col-md-4 panel">
                    <label for="exampleInputEmail1"> Patient</label>
                    <select class="form-control m-bot15 js-example-basic-single pos_select" id="pos_select" name="patient" value="">
                        <option value="">Select .....</option>
                        <option value="1">Mr Patient </option>
                    </select>
                </div>
                <div class="col-md-4 panel">
                    <label for="exampleInputEmail1"> Doctor</label>
                    <select class="form-control m-bot15" id="adoctors" name="doctor" value=""> </select>
                </div>

                <div class="col-md-4 panel">
                    <label for="exampleInputEmail1"> Date</label>
                    <input type="text" class="form-control default-date-picker" id="date" readonly="" name="date" id="exampleInputEmail1" value="" placeholder="" />
                </div>

                <div class="col-md-6 panel">
                    <label class="">Available Slots</label>
                    <select class="form-control m-bot15" name="time_slot" id="aslots" value=""> </select>
                </div>

                <div class="col-md-6 panel">
                    <label for="exampleInputEmail1"> Appointment Status</label>
                    <select class="form-control m-bot15" name="status" value="">
                        <option value="Requested"> Requested </option>
                    </select>
                </div>

                <div class="col-md-8 panel">
                    <label for="exampleInputEmail1"> Remarks</label>
                    <input type="text" class="form-control" name="remarks" id="exampleInputEmail1" value="" placeholder="" />
                </div>

                <div class="col-md-5 panel"><input type="checkbox" name="sms" value="sms" /> Send SMS<br /></div>

                <input type="hidden" name="redirect" value="patient/medicalHistory?id=1" />

                <input type="hidden" name="request" value="Yes" />

                <div class="col-md-12 panel">
                    <button type="submit" name="submit" class="btn btn-info pull-right">Submit</button>
                </div>
            </form>
        </div>
    </div>
    <!-- /.modal-content -->
</div>
<!-- /.modal-dialog -->

<!-- Add Appointment Modal-->

<!-- Edit Event Modal-->
<div class="modal fade" id="editAppointmentModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog modal-lg"">
    <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            <h4 class="modal-title">Edit Appointment</h4>
        </div>
        <div class="modal-body">
            <form role="form" id="editAppointmentForm" class="clearfix row" action="appointment/addNew" method="post" enctype="multipart/form-data">
                <div class="col-md-4 panel">
                    <label for="exampleInputEmail1"> Patient</label>
                    <select class="form-control m-bot15 js-example-basic-single pos_select patient" id="pos_select" name="patient" value="">
                        <option value="">Select .....</option>
                        <option value="1">Mr Patient </option>
                    </select>
                </div>

                <div class="col-md-4 panel">
                    <label for="exampleInputEmail1"> Doctor</label>
                    <select class="form-control m-bot15 doctor" id="adoctors1" name="doctor" value=""> </select>
                </div>

                <div class="col-md-4 panel">
                    <label for="exampleInputEmail1"> Date</label>
                    <input type="text" class="form-control default-date-picker" readonly="" id="date1" name="date" id="exampleInputEmail1" value="" placeholder="" />
                </div>

                <div class="col-md-6 panel">
                    <label class="">Available Slots</label>
                    <select class="form-control m-bot15" name="time_slot" id="aslots1" value=""> </select>
                </div>

                <div class="col-md-6 panel">
                    <label for="exampleInputEmail1"> Appointment Status</label>
                    <select class="form-control m-bot15" name="status" value="">
                        <option value="Requested"> Requested </option>
                    </select>
                </div>

                <div class="col-md-8 panel">
                    <label for="exampleInputEmail1"> Remarks</label>
                    <input type="text" class="form-control" name="remarks" id="exampleInputEmail1" value="" placeholder="" />
                </div>

                <div class="col-md-6 panel"><input type="checkbox" name="sms" value="sms" /> Send SMS<br /></div>

                <input type="hidden" name="redirect" value="patient/medicalHistory?id=1" />>
                <input type="hidden" name="id" id="appointment_id" value="" />

                <div class="col-md-12 panel">
                    <button type="submit" name="submit" class="btn btn-info pull-right">Submit</button>
                </div>
            </form>
        </div>
    </div>
    <!-- /.modal-content -->
</div>
<!-- /.modal-dialog -->

<!-- Edit Event Modal-->

<!-- Edit Patient Modal-->
<div class="modal fade" id="infoModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title">Edit Patient</h4>
            </div>
            <div class="modal-body row">
                <form role="form" id="editPatientForm" action="patient/addNew" class="clearfix" method="post" enctype="multipart/form-data">
                    <div class="form-group col-md-6">
                        <label for="exampleInputEmail1">Name</label>
                        <input type="text" class="form-control" name="name" id="exampleInputEmail1" value="" placeholder="" />
                    </div>

                    <div class="form-group col-md-6">
                        <label for="exampleInputEmail1">Email</label>
                        <input type="text" class="form-control" name="email" id="exampleInputEmail1" value="" placeholder="" />
                    </div>

                    <div class="form-group col-md-6">
                        <label for="exampleInputEmail1">Password</label>
                        <input type="password" class="form-control" name="password" id="exampleInputEmail1" placeholder="" />
                    </div>

                    <div class="form-group col-md-6">
                        <label for="exampleInputEmail1">Address</label>
                        <input type="text" class="form-control" name="address" id="exampleInputEmail1" value="" placeholder="" />
                    </div>
                    <div class="form-group col-md-6">
                        <label for="exampleInputEmail1">Phone</label>
                        <input type="text" class="form-control" name="phone" id="exampleInputEmail1" value="" placeholder="" />
                    </div>
                    <div class="form-group col-md-6">
                        <label for="exampleInputEmail1">Sex</label>
                        <select class="form-control m-bot15" name="sex" value="">
                            <option value="Male" selected> Male </option>
                            <option value="Female"> Female </option>
                            <option value="Others"> Others </option>
                        </select>
                    </div>

                    <div class="form-group col-md-6">
                        <label>Birth Date</label>
                        <input class="form-control form-control-inline input-medium default-date-picker" type="text" name="birthdate" value="" placeholder="" readonly="" />
                    </div>

                    <div class="form-group col-md-6">
                        <label for="exampleInputEmail1">Blood Group</label>
                        <select class="form-control m-bot15" name="bloodgroup" value=""> </select>
                    </div>

                    <div class="form-group col-md-6">
                        <label for="exampleInputEmail1">Doctor</label>
                        <select class="form-control js-example-basic-single doctor" name="doctor" value="">
                            <option value=""> </option>

                            <option value="1">Mr Doctor </option>

                            <option value="202">Sabbir hossain </option>

                            <option value="203">Mahbub hossain </option>

                            <option value="204">Sojib mahmud </option>
                        </select>
                    </div>

                    <div class="form-group last col-md-6">
                        <label class="control-label">Image Upload</label>
                        <div class="">
                            <div class="fileupload fileupload-new" data-provides="fileupload">
                                <div class="fileupload-new thumbnail" style="width: 200px; height: 150px;">
                                    <img src="//www.placehold.it/200x150/EFEFEF/AAAAAA&amp;text=no+image" id="img" alt="" />
                                </div>
                                <div class="fileupload-preview fileupload-exists thumbnail" style="max-width: 200px; max-height: 150px; line-height: 20px;"></div>
                                <div>
                                    <span class="btn btn-white btn-file">
                                        <span class="fileupload-new"><i class="fa fa-paper-clip"></i> Select image</span>
                                        <span class="fileupload-exists"><i class="fa fa-undo"></i> Change</span>
                                        <input type="file" class="default" name="img_url" />
                                    </span>
                                    <a href="#" class="btn btn-danger fileupload-exists" data-dismiss="fileupload"><i class="fa fa-trash"></i> Remove</a>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!--

                    <div class="form-group last col-md-6">
                        <div style="text-align:center;">
                            <video id="video" width="200" height="200" autoplay></video>
                            <div class="snap" id="snap">Capture Photo</div>
                            <canvas id="canvas" width="200" height="200"></canvas>
                            Right click on the captured image and save. Then select the saved image from the left side's Select Image button.
                        </div>
                    </div>

                    -->

                    <div class="form-group col-md-6"><input type="checkbox" name="sms" value="sms" /> Send SMS<br /></div>

                    <input type="hidden" name="redirect" value="patient/medicalHistory?id=1" />>

                    <input type="hidden" name="id" value="" />
                    <input type="hidden" name="p_id" value="101223" />

                    <section class="col-md-12">
                        <button type="submit" name="submit" class="btn btn-info pull-right">Submit</button>
                    </section>
                </form>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
</div>
<!-- Edit Patient Modal-->

<style>
    thead {
        background: #f1f1f1;
        border-bottom: 1px solid #ddd;
    }

    .btn_width {
        margin-bottom: 20px;
    }

    .tab-content {
        padding: 20px 0px;
    }

    .cke_editable {
        min-height: 1000px;
    }
</style>

<script type="text/javascript">
    $(document).ready(function () {
        $(".editbutton").click(function (e) {
            e.preventDefault(e);
            // Get the record's ID via attribute
            var iid = $(this).attr("data-id");
            $("#myModal2").modal("show");
            $.ajax({
                url: "patient/editMedicalHistoryByJason?id=" + iid,
                method: "GET",
                data: "",
                dataType: "json",
            }).success(function (response) {
                // Populate the form fields with the data returned from server
                var date = new Date(response.medical_history.date * 1000);
                var de = date.getDate() + "-" + (date.getMonth() + 1) + "-" + date.getFullYear();

                $("#medical_historyEditForm").find('[name="id"]').val(response.medical_history.id).end();
                $("#medical_historyEditForm").find('[name="date"]').val(de).end();
                $("#medical_historyEditForm").find('[name="title"]').val(response.medical_history.title).end();
                CKEDITOR.instances["editor"].setData(response.medical_history.description);
            });
        });
    });
</script>

<script type="text/javascript">
    $(document).ready(function () {
        $(".editPrescription").click(function (e) {
            e.preventDefault(e);
            // Get the record's ID via attribute
            var iid = $(this).attr("data-id");
            $("#myModal5").modal("show");
            $.ajax({
                url: "prescription/editPrescriptionByJason?id=" + iid,
                method: "GET",
                data: "",
                dataType: "json",
            }).success(function (response) {
                // Populate the form fields with the data returned from server
                $("#prescriptionEditForm").find('[name="id"]').val(response.prescription.id).end();
                $("#prescriptionEditForm").find('[name="patient"]').val(response.prescription.patient).end();
                $("#prescriptionEditForm").find('[name="doctor"]').val(response.prescription.doctor).end();

                CKEDITOR.instances["editor1"].setData(response.prescription.symptom);
                CKEDITOR.instances["editor2"].setData(response.prescription.medicine);
                CKEDITOR.instances["editor3"].setData(response.prescription.note);
            });
        });
    });
</script>

<script type="text/javascript">
    $(document).ready(function () {
        $(".editAppointmentButton").click(function (e) {
            e.preventDefault(e);
            // Get the record's ID via attribute
            var iid = $(this).attr("data-id");
            var id = $(this).attr("data-id");

            $("#editAppointmentForm").trigger("reset");
            $("#editAppointmentModal").modal("show");
            $.ajax({
                url: "appointment/editAppointmentByJason?id=" + iid,
                method: "GET",
                data: "",
                dataType: "json",
            }).success(function (response) {
                var de = response.appointment.date * 1000;
                var d = new Date(de);
                var da = d.getDate() + "-" + (d.getMonth() + 1) + "-" + d.getFullYear();
                // Populate the form fields with the data returned from server
                $("#editAppointmentForm").find('[name="id"]').val(response.appointment.id).end();
                $("#editAppointmentForm").find('[name="patient"]').val(response.appointment.patient).end();
                //  $('#editAppointmentForm').find('[name="doctor"]').val(response.appointment.doctor).end()
                $("#editAppointmentForm").find('[name="date"]').val(da).end();
                $("#editAppointmentForm").find('[name="status"]').val(response.appointment.status).end();
                $("#editAppointmentForm").find('[name="remarks"]').val(response.appointment.remarks).end();
                var option1 = new Option(response.doctor.name + "-" + response.doctor.id, response.doctor.id, true, true);
                $("#editAppointmentForm").find('[name="doctor"]').append(option1).trigger("change");
                // $('.js-example-basic-single.doctor').val(response.appointment.doctor).trigger('change');
                $(".js-example-basic-single.patient").val(response.appointment.patient).trigger("change");

                var date = $("#date1").val();
                var doctorr = $("#adoctors1").val();
                var appointment_id = $("#appointment_id").val();
                // $('#default').trigger("reset");
                $.ajax({
                    url: "schedule/getAvailableSlotByDoctorByDateByAppointmentIdByJason?date=" + date + "&doctor=" + doctorr + "&appointment_id=" + appointment_id,
                    method: "GET",
                    data: "",
                    dataType: "json",
                }).success(function (response) {
                    $("#aslots1").find("option").remove();
                    var slots = response.aslots;
                    $.each(slots, function (key, value) {
                        $("#aslots1").append($("<option>").text(value).val(value)).end();
                    });

                    $("#aslots1")
                        .val(response.current_value)
                        .find("option[value=" + response.current_value + "]")
                        .attr("selected", true);
                    //  $('#aslots1 option[value=' + response.current_value + ']').attr("selected", "selected");
                    //   $("#default-step-1 .button-next").trigger("click");
                    if ($("#aslots1").has("option").length == 0) {
                        //if it is blank.
                        $("#aslots1").append($("<option>").text("No Further Time Slots").val("Not Selected")).end();
                    }
                    // Populate the form fields with the data returned from server
                    //  $('#default').find('[name="staff"]').val(response.appointment.staff).end()
                });
            });
        });
    });
</script>

<script type="text/javascript">
    $(document).ready(function () {
        $("#adoctors").change(function () {
            // Get the record's ID via attribute
            var iid = $("#date").val();
            var doctorr = $("#adoctors").val();
            $("#aslots").find("option").remove();
            // $('#default').trigger("reset");
            $.ajax({
                url: "schedule/getAvailableSlotByDoctorByDateByJason?date=" + iid + "&doctor=" + doctorr,
                method: "GET",
                data: "",
                dataType: "json",
            }).success(function (response) {
                var slots = response.aslots;
                $.each(slots, function (key, value) {
                    $("#aslots").append($("<option>").text(value).val(value)).end();
                });
                //   $("#default-step-1 .button-next").trigger("click");
                if ($("#aslots").has("option").length == 0) {
                    //if it is blank.
                    $("#aslots").append($("<option>").text("No Further Time Slots").val("Not Selected")).end();
                }
                // Populate the form fields with the data returned from server
                //  $('#default').find('[name="staff"]').val(response.appointment.staff).end()
            });
        });
    });

    $(document).ready(function () {
        var iid = $("#date").val();
        var doctorr = $("#adoctors").val();
        $("#aslots").find("option").remove();
        // $('#default').trigger("reset");
        $.ajax({
            url: "schedule/getAvailableSlotByDoctorByDateByJason?date=" + iid + "&doctor=" + doctorr,
            method: "GET",
            data: "",
            dataType: "json",
        }).success(function (response) {
            var slots = response.aslots;
            $.each(slots, function (key, value) {
                $("#aslots").append($("<option>").text(value).val(value)).end();
            });
            //   $("#default-step-1 .button-next").trigger("click");
            if ($("#aslots").has("option").length == 0) {
                //if it is blank.
                $("#aslots").append($("<option>").text("No Further Time Slots").val("Not Selected")).end();
            }
            // Populate the form fields with the data returned from server
            //  $('#default').find('[name="staff"]').val(response.appointment.staff).end()
        });
    });

    $(document).ready(function () {
        $("#date")
            .datepicker({
                format: "dd-mm-yyyy",
                autoclose: true,
            })
            //Listen for the change even on the input
            .change(dateChanged)
            .on("changeDate", dateChanged);
    });

    function dateChanged() {
        // Get the record's ID via attribute
        var iid = $("#date").val();
        var doctorr = $("#adoctors").val();
        $("#aslots").find("option").remove();
        // $('#default').trigger("reset");
        $.ajax({
            url: "schedule/getAvailableSlotByDoctorByDateByJason?date=" + iid + "&doctor=" + doctorr,
            method: "GET",
            data: "",
            dataType: "json",
        }).success(function (response) {
            var slots = response.aslots;
            $.each(slots, function (key, value) {
                $("#aslots").append($("<option>").text(value).val(value)).end();
            });
            //   $("#default-step-1 .button-next").trigger("click");
            if ($("#aslots").has("option").length == 0) {
                //if it is blank.
                $("#aslots").append($("<option>").text("No Further Time Slots").val("Not Selected")).end();
            }

            // Populate the form fields with the data returned from server
            //  $('#default').find('[name="staff"]').val(response.appointment.staff).end()
        });
    }
</script>

<script type="text/javascript">
    $(document).ready(function () {
        $("#adoctors1").change(function () {
            // Get the record's ID via attribute
            var id = $("#appointment_id").val();
            var date = $("#date1").val();
            var doctorr = $("#adoctors1").val();
            $("#aslots1").find("option").remove();
            // $('#default').trigger("reset");
            $.ajax({
                url: "schedule/getAvailableSlotByDoctorByDateByAppointmentIdByJason?date=" + date + "&doctor=" + doctorr + "&appointment_id=" + id,
                method: "GET",
                data: "",
                dataType: "json",
            }).success(function (response) {
                var slots = response.aslots;
                $.each(slots, function (key, value) {
                    $("#aslots1").append($("<option>").text(value).val(value)).end();
                });
                //   $("#default-step-1 .button-next").trigger("click");
                if ($("#aslots1").has("option").length == 0) {
                    //if it is blank.
                    $("#aslots1").append($("<option>").text("No Further Time Slots").val("Not Selected")).end();
                }
                // Populate the form fields with the data returned from server
                //  $('#default').find('[name="staff"]').val(response.appointment.staff).end()
            });
        });
    });

    $(document).ready(function () {
        var id = $("#appointment_id").val();
        var date = $("#date1").val();
        var doctorr = $("#adoctors1").val();
        $("#aslots1").find("option").remove();
        // $('#default').trigger("reset");
        $.ajax({
            url: "schedule/getAvailableSlotByDoctorByDateByAppointmentIdByJason?date=" + date + "&doctor=" + doctorr + "&appointment_id=" + id,
            method: "GET",
            data: "",
            dataType: "json",
        }).success(function (response) {
            var slots = response.aslots;
            $.each(slots, function (key, value) {
                $("#aslots1").append($("<option>").text(value).val(value)).end();
            });
            //   $("#default-step-1 .button-next").trigger("click");
            if ($("#aslots1").has("option").length == 0) {
                //if it is blank.
                $("#aslots1").append($("<option>").text("No Further Time Slots").val("Not Selected")).end();
            }
            // Populate the form fields with the data returned from server
            //  $('#default').find('[name="staff"]').val(response.appointment.staff).end()
        });
    });

    $(document).ready(function () {
        $("#date1")
            .datepicker({
                format: "dd-mm-yyyy",
                autoclose: true,
            })
            //Listen for the change even on the input
            .change(dateChanged1)
            .on("changeDate", dateChanged1);
    });

    function dateChanged1() {
        // Get the record's ID via attribute
        var id = $("#appointment_id").val();
        var iid = $("#date1").val();
        var doctorr = $("#adoctors1").val();
        $("#aslots1").find("option").remove();
        // $('#default').trigger("reset");
        $.ajax({
            url: "schedule/getAvailableSlotByDoctorByDateByAppointmentIdByJason?date=" + iid + "&doctor=" + doctorr + "&appointment_id=" + id,
            method: "GET",
            data: "",
            dataType: "json",
        }).success(function (response) {
            var slots = response.aslots;
            $.each(slots, function (key, value) {
                $("#aslots1").append($("<option>").text(value).val(value)).end();
            });
            //   $("#default-step-1 .button-next").trigger("click");
            if ($("#aslots1").has("option").length == 0) {
                //if it is blank.
                $("#aslots1").append($("<option>").text("No Further Time Slots").val("Not Selected")).end();
            }

            // Populate the form fields with the data returned from server
            //  $('#default').find('[name="staff"]').val(response.appointment.staff).end()
        });
    }
</script>

<script type="text/javascript">
    $(document).ready(function () {
        $(".editPatient").click(function () {
            //    e.preventDefault(e);
            // Get the record's ID via attribute
            var iid = $(this).attr("data-id");
            $("#editPatientForm").trigger("reset");
            $.ajax({
                url: "patient/editPatientByJason?id=" + iid,
                method: "GET",
                data: "",
                dataType: "json",
            }).success(function (response) {
                // Populate the form fields with the data returned from server

                $("#editPatientForm").find('[name="id"]').val(response.patient.id).end();
                $("#editPatientForm").find('[name="name"]').val(response.patient.name).end();
                $("#editPatientForm").find('[name="password"]').val(response.patient.password).end();
                $("#editPatientForm").find('[name="email"]').val(response.patient.email).end();
                $("#editPatientForm").find('[name="address"]').val(response.patient.address).end();
                $("#editPatientForm").find('[name="phone"]').val(response.patient.phone).end();
                $("#editPatientForm").find('[name="sex"]').val(response.patient.sex).end();
                $("#editPatientForm").find('[name="birthdate"]').val(response.patient.birthdate).end();
                $("#editPatientForm").find('[name="bloodgroup"]').val(response.patient.bloodgroup).end();
                $("#editPatientForm").find('[name="p_id"]').val(response.patient.patient_id).end();

                if (typeof response.patient.img_url !== "undefined" && response.patient.img_url != "") {
                    $("#img").attr("src", response.patient.img_url);
                }

                $(".js-example-basic-single.doctor").val(response.patient.doctor).trigger("change");
                $("#infoModal").modal("show");
            });
        });
    });
</script>

<script>
    $(document).ready(function () {
        $("#adoctors").select2({
            placeholder: "Search Doctor Name / ID",
            allowClear: true,
            ajax: {
                url: "doctor/getDoctorInfo",
                type: "post",
                dataType: "json",
                delay: 250,
                data: function (params) {
                    return {
                        searchTerm: params.term, // search term
                    };
                },
                processResults: function (response) {
                    return {
                        results: response,
                    };
                },
                cache: true,
            },
        });
        $("#adoctors1").select2({
            placeholder: "Search Doctor Name / ID",
            allowClear: true,
            ajax: {
                url: "doctor/getDoctorInfo",
                type: "post",
                dataType: "json",
                delay: 250,
                data: function (params) {
                    return {
                        searchTerm: params.term, // search term
                    };
                },
                processResults: function (response) {
                    return {
                        results: response,
                    };
                },
                cache: true,
            },
        });
    });
</script>
<script>
    $(document).ready(function () {
        $(".flashmessage").delay(3000).fadeOut(100);
    });
</script>


@endsection
