@extends('layouts.website.website')
@section('content')

    <!--main content start-->
    <section id="main-content">
        <section class="wrapper site-min-height">
            <!-- page start-->
            <section class="col-md-12">
                <header class="panel-heading">
                    Lab Report
                    <div class="col-md-4 no-print pull-right">
                        <a href="lab/addLabView">
                            <div class="btn-group pull-right">
                                <button id="" class="btn green btn-xs"><i class="fa fa-plus-circle"></i> Add Lab Report</button>
                            </div>
                        </a>
                    </div>
                </header>
                <div class="panel-body">
                    <div class="adv-table editable-table">
                        <div class="space15"></div>
                        <table class="table table-striped table-hover table-bordered" id="editable-sample">
                            <thead>
                                <tr>
                                    <th>Report Id</th>
                                    <th>Patient</th>
                                    <th>Doctor</th>
                                    <th>Date</th>
                                    <th class="">Options</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($DoctorLab as $item)
                                    <tr>
                                        <td>{{ $item->id }}</td>
                                        <td>{{ $item->patient->name }}</td>
                                        <td>{{ $item->doctor->name }}</td>
                                        <td>{{ Carbon\Carbon::parse($item->date)->format("d,m Y h:i") }}</td>
                                        <td>
                                            {{-- <a class="btn btn-info btn-xs editbutton" title="edit" href="lab?id=1939"><i class="fa fa-edit"> </i> </a> --}}
                                            <a class="btn btn-xs invoicebutton" title="invoice" style="color: #fff;" href="{{ route('website_lab_view',$item->id) }}"><i class="fa fa-file"></i> </a>
                                            <a class="btn btn-info btn-xs delete_button" title="حذف" href="{{ route('delete_lab',$item->id) }}" onclick="return confirm('Are you sure you want to delete this item?');"><i class="fa fa-trash"></i></a>
                                        </td>

                                    </tr>
                                @endforeach
                                <style>
                                    .img_url {
                                        height: 20px;
                                        width: 20px;
                                        background-size: contain;
                                        max-height: 20px;
                                        border-radius: 100px;
                                    }
                                    .option_th {
                                        width: 18%;
                                    }
                                </style>
                            </tbody>
                        </table>
                    </div>
                </div>
            </section>
            <!-- page end-->
        </section>
    </section>

    <style>
        .note-editable  table tr td{
            border-bottom: 1px solid black;
            border-left: 1px solid black;
            border-top: 1px solid black;
            border-right: 1px solid black;
        }
        .note-editable table tr td{
            border: 1px solid balck!important;
        }
    </style>

    <script>
        $(document).ready(function () {
            $('.pos_client').hide();
            $(document.body).on('change', '#pos_select', function () {

                var v = $("select.pos_select option:selected").val()
                if (v == 'add_new') {
                    $('.pos_client').show();
                } else {
                    $('.pos_client').hide();
                }
            });
        });
    </script>

    <script>
        $(document).ready(function () {
            $('.pos_doctor').hide();
            $(document.body).on('change', '#add_doctor', function () {

                var v = $("select.add_doctor option:selected").val()
                if (v == 'add_new') {
                    $('.pos_doctor').show();
                } else {
                    $('.pos_doctor').hide();
                }
            });

        });
    </script>

    <script type="text/javascript">
        $(document).ready(function () {
            $(document.body).on('change', '#template', function () {
                var iid = $("select.template option:selected").val();
                // $.ajax({
                //     url: 'lab/getTemplateByIdByJason?id=' + iid,
                //     method: 'GET',
                //     data: '',
                //     dataType: 'json',
                // }).success(function (response) {
                //     var data = CKEDITOR.instances.editor.getData();
                //     if (response.template.template != null) {
                //         var data1 = data + response.template.template;
                //     } else {
                //         var data1 = data;
                //     }
                //     CKEDITOR.instances['editor'].setData(data1)
                // });
            });
        });
    </script>

    <script>
        $(document).ready(function () {
            $("#pos_select").select2({
                placeholder: 'Search Patient Name / ID',
                allowClear: true,
                // ajax: {
                //     url: 'patient/getPatientinfoWithAddNewOption',
                //     type: "post",
                //     dataType: 'json',
                //     delay: 250,
                //     data: function (params) {
                //         return {
                //             searchTerm: params.term // search term
                //         };
                //     },
                //     processResults: function (response) {
                //         return {
                //             results: response
                //         };
                //     },
                //     cache: true
                // }

            });

            $("#add_doctor").select2({
                placeholder: 'Search Doctor Name / ID',
                allowClear: true,
                // ajax: {
                //     url: 'doctor/getDoctorWithAddNewOption',
                //     type: "post",
                //     dataType: 'json',
                //     delay: 250,
                //     data: function (params) {
                //         return {
                //             searchTerm: params.term // search term
                //         };
                //     },
                //     processResults: function (response) {
                //         return {
                //             results: response
                //         };
                //     },
                //     cache: true
                // }

            });

        });
    </script>
@endsection
