@extends('layouts.website.website')
@section('content')
    <!--main content start-->
<script type="text/javascript" src="common/js/google-loader.js"></script>
<section id="main-content">
    <section class="wrapper site-min-height">
        <!--state overview start-->
        <div class="modal fade" tabindex="-1" role="dialog" id="cmodal">
            <div class="modal-dialog modal-lg" role="document" style="width: 80%;">
                <div class="modal-content">

                    <div id="medical_history">
                        <div class="col-md-12"></div>
                    </div>
                    <div class="modal-footer">
                        <div class="col-md-12">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>



        <div class="state-overview col-md-12" style="padding: 12px 0px;">
            <div class="clearfix">
                <div class="col-lg-12 col-sm-6">
                    <a href="/doctor">
                        <section class="panel home_sec_green">
                            <div class="symbol green">
                                <i class="fa fa-user-md"></i>
                            </div>
                            <div class="value">
                                <h3 class="">
                                    @php
                                        $doctors = App\User::where('role_id',4)->count();
                                    @endphp
                                    {{ $doctors }}
                                </h3>
                                <p>Doctor(s)</p>
                            </div>
                        </section>
                        <div class="col-lg-3 col-sm-6">
                            <a href="/patient">
                                <section class="panel home_sec_blue">
                                    <div class="symbol blue">
                                        <i class="fa fa-users-medical"></i>
                                    </div>
                                    <div class="value">
                                        <h3 class="">
                                            @php
                                                $patient = App\User::where('role_id',8)->count();
                                            @endphp
                                            {{ $patient }}
                                        </h3>
                                        <p>Patient(s)</p>
                                    </div>
                                </section>
                            </a>
                        </div>

                        <div class="col-lg-3 col-sm-6">
                            <a href="/appointment">
                                <section class="panel home_sec_yellow">
                                    <div class="symbol yellow">
                                        <i class="fa fa-calendar"></i>
                                    </div>
                                    <div class="value">
                                        <h3 class="">
                                            @php
                                                $appointment = App\DoctorAppoinment::count();
                                            @endphp
                                            {{ $appointment }}
                                        </h3>
                                        <p>Appointment(s)</p>
                                    </div>
                                </section>
                            </a>
                        </div>

                        <div class="col-lg-3 col-sm-6">
                            <a href="/prescription/all">
                                <section class="panel home_sec_green">
                                    <div class="symbol blue">
                                        <i class="fa fa-file-medical"></i>
                                    </div>
                                    <div class="value">
                                        <h3 class="">
                                            @php
                                                $prescription = App\DoctorPrescription::count();
                                            @endphp
                                            {{ $prescription }}
                                        </h3>
                                        <p>Prescription</p>
                                    </div>
                                </section>
                            </a>
                        </div>

                        <div class="col-lg-3 col-sm-6">
                            <a href="/patient/caseList">
                                <section class="panel home_sec_blue">
                                    <div class="symbol blue">
                                        <i class="fa fa-medkit"></i>
                                    </div>
                                    <div class="value">
                                        <h3 class="">
                                            @php
                                                $case = App\PatientCase::count();
                                            @endphp
                                            {{ $case }}
                                        </h3>
                                        <p>Case History</p>
                                    </div>
                                </section>
                            </a>
                        </div>

                        <div class="col-lg-3 col-sm-6">
                            <a href="/lab">
                                <section class="panel home_sec_green">
                                    <div class="symbol green">
                                        <i class="fa fa-flask"></i>
                                    </div>
                                    <div class="value">
                                        <h3 class="">
                                            @php
                                                $case = App\PatientCase::count();
                                            @endphp
                                            {{ $case }}
                                        </h3>
                                        <p>Lab Report(s)</p>
                                    </div>
                                </section>
                            </a>
                        </div>

                        <div class="col-lg-3 col-sm-6">
                            <a href="/patient/documents">
                                <section class="panel home_sec_blue">
                                    <div class="symbol blue">
                                        <i class="fa fa-file"></i>
                                    </div>
                                    <div class="value">
                                        <h3 class="">
                                            @php
                                                $document = App\PatientDocument::count();
                                            @endphp
                                            {{ $document }}
                                        </h3>
                                        <p>Document(s)</p>
                                    </div>
                                </section>
                            </a>
                        </div>
                        <div class="col-lg-3 col-sm-6">
                            <a href="/finance/payment">
                                <section class="panel home_sec_yellow">
                                    <div class="symbol yellow">
                                        <i class="fa fa-money-check"></i>
                                    </div>
                                    <div class="value">
                                        <h3 class="">
                                            3
                                        </h3>
                                        <p>Payment Invoice</p>
                                    </div>
                                </section>
                            </a>
                        </div>

                        <!--


                                        <div class="col-lg-4 col-sm-12">
                                                                                                                                                                                                                        <a href="medicine">
                                                                    <section class="panel home_sec_blue">
                                                    <div class="symbol blue">
                                                        <i class="fa fa-medkit"></i>
                                                    </div>
                                                    <div class="value">
                                                        <h3 class="">
                    3                                                        </h3>
                                                        <p>Medicine</p>
                                                    </div>
                                                </section>
                                                                                                                                                                                                                        </a>
                                                            </div>


                                                                                                                                                                                                                                    <div class="col-lg-6 col-sm-12">
                                                                                                                                                                                                                <a href="finance/payment">
                                                                                                                                                                                                                <section class="panel">
                                                                                                                                                                                                                <div class="symbol terques">
                                                                                                                                                                                                                <i class="fa fa-bar-chart-o"></i>
                                                                                                                                                                                                                </div>
                                                                                                                                                                                                                <div class="value">
                                                                                                                                                                                                                <h3 class=" count14">
                        $ 7,510.00                                                                                                                                                                                                                </h3>
                                                                                                                                                                                                                <p>Total payment</p>
                                                                                                                                                                                                                </div>
                                                                                                                                                                                                                </section>
                                                                                                                                                                                                                </a>
                                                                                                                                                                                                                </div>


                                                                                                                                                                                                                <div class="col-lg-6 col-sm-12">
                                                                                                                                                                                                                                            <a href="settings">
                                                                                                                                                                                                                                        <section class="panel">
                                                                                                                                                                                                                <div class="symbol blue">
                                                                                                                                                                                                                <i class="fa fa-cogs"></i>
                                                                                                                                                                                                                </div>
                                                                                                                                                                                                                <div class="value">
                                                                                                                                                                                                                <h3 class="">

                                                                                                                                                                                                                </h3>
                                                                                                                                                                                                                <p>Settings</p>
                                                                                                                                                                                                                </div>
                                                                                                                                                                                                                </section>
                                                                                                                                                                                                                                            </a>
                                                                                                                                                                                                                                        </div>



                    -->

                        <div class="col-lg-8 col-sm-12">
                            <div id="chart_div" class="panel" style=""></div>
                        </div>

                        <div class="col-lg-4 col-sm-6">
                            <div id="piechart_3d" class="panel" style=""></div>
                        </div>

                        <div class="col-lg-5 col-sm-6">
                            <div id="donutchart" class="panel" style=""></div>
                        </div>

                        <div class="col-md-7 col-sm-12">
                            <section class="panel">
                                <header class="panel-heading">
                                    Notice
                                </header>
                                <div class="panel col-md-12">
                                    <div class="task-content panel">
                                        <ul class="task-list">
                                            <table class="table table-striped table-hover table-bordered" id="editable-sample">
                                                <thead>
                                                    <tr>
                                                        <th>Title</th>
                                                        <th>Description</th>
                                                    </tr>
                                                </thead>
                                                <tbody></tbody>
                                            </table>
                                        </ul>

                                        <div class="panel col-md-12 add-task-row">
                                            <a class="btn btn-success btn-sm pull-left" href="notice/addNewView">Add Notice</a>
                                            <a class="btn btn-default btn-sm pull-right" href="notice">All Notice</a>
                                        </div>
                                    </div>
                                </div>
                            </section>
                        </div>

                        <div class="col-md-8">
                            <aside class="calendar_ui panel calendar_ui">
                                <section class="">
                                    <div class="">
                                        <div id="calendar" class="has-toolbar calendar_view"></div>
                                    </div>
                                </section>
                            </aside>
                        </div>

                        <div class="col-md-4">
                            <section class="panel">
                                <header class="panel-heading">
                                    Tue 06 October, 2020
                                </header>
                                <div class="panel-body">
                                    <div class="home_section">
                                        Income : $1,850.00
                                        <hr />
                                    </div>
                                    <div class="home_section">
                                        Expense : $0.00
                                        <hr />
                                    </div>
                                    <div class="home_section">
                                        Appointment : 1
                                        <hr />
                                    </div>
                                </div>
                            </section>

                            <section class="panel">
                                <header class="panel-heading">
                                    October, 2020
                                </header>
                                <div class="panel-body">
                                    <div class="home_section">
                                        Income : $7,510.00
                                        <hr />
                                    </div>
                                    <div class="home_section">
                                        Expense : $5,000.00
                                        <hr />
                                    </div>
                                    <div class="home_section">
                                        Appointment : 4
                                        <hr />
                                    </div>
                                </div>
                            </section>

                            <section class="panel">
                                <header class="panel-heading">
                                    2020
                                </header>
                                <div class="panel-body">
                                    <div class="home_section">
                                        Income : $7,510.00
                                        <hr />
                                    </div>
                                    <div class="home_section">
                                        Expense : $5,000.00
                                        <hr />
                                    </div>
                                    <div class="home_section">
                                        Appointment : 4
                                        <hr />
                                    </div>
                                </div>
                            </section>
                        </div>

                        <style>
                            table {
                                box-shadow: none;
                            }

                            .fc-head {
                                box-shadow: 0 2px 5px 0 rgba(0, 0, 0, 0.16), 0 2px 10px 0 rgba(0, 0, 0, 0.12);
                            }

                            .panel-body {
                                background: #fff;
                            }

                            thead {
                                background: #fff;
                            }

                            .panel-body {
                                background: #fff;
                            }

                            .state-overview .panel-heading {
                                border-radius: 0px;
                                background: #fff !important;
                                color: #000;
                                padding-left: 10px;
                                font-size: 13px !important;
                                margin-top: 3px;
                                text-align: center;
                            }

                            .add_patient {
                                background: #009988;
                            }

                            .add_appointment {
                                background: #f8d347;
                            }

                            .add_prescription {
                                background: blue;
                            }

                            .add_lab_report {
                            }

                            .y-axis li span {
                                display: block;
                                margin: -20px 0 0 -25px;
                                padding: 0 20px;
                                width: 40px;
                            }

                            .sale_color {
                                background: #69d2e7 !important;
                                padding: 10px !important;
                                font-size: 5px;
                                margin-right: 10px;
                            }

                            .expense_color {
                                background: #f38630 !important;
                                padding: 10px !important;
                                font-size: 5px;
                                margin-right: 10px;
                            }

                            audio,
                            canvas,
                            progress,
                            video {
                                display: inline-block;
                                vertical-align: baseline;
                                width: 100% !important;
                                height: 101% !important;
                                margin-bottom: 18%;
                            }

                            .panel-heading {
                                margin-top: 0px;
                            }

                            .wrapper {
                                margin-top: 50px;
                                padding: 0px 10px 0px 0px !important;
                                padding: 11px 20px 0px 10px !important;
                            }
                        </style>
                    </a>
                </div>
            </div>
        </div>
    </section>
</section>

<script type="text/javascript">
    google.charts.load("current", {packages: ["corechart"]});
    google.charts.setOnLoadCallback(drawChart);
    function drawChart() {

        var months = ["January", "February", "March", "April", "May", "June",
            "July", "August", "September", "October", "November", "December"];

        var d = new Date();
        var selectedMonthName = months[d.getMonth()] + ', ' + d.getFullYear();


        var data = google.visualization.arrayToDataTable([
            ['Task', 'Hours per Day'],
            ['Income', 7510],
            ['Expense', 5000],
        ]);

        var options = {
            title: selectedMonthName,
            is3D: true,
        };

        var chart = new google.visualization.PieChart(document.getElementById('piechart_3d'));
        chart.draw(data, options);
    }
</script>




<script type="text/javascript">
    google.charts.load("current", {packages: ["corechart"]});
    google.charts.setOnLoadCallback(drawChart);
    function drawChart() {

        var months = ["January", "February", "March", "April", "May", "June",
            "July", "August", "September", "October", "November", "December"];

        var d = new Date();
        var selectedMonthName = months[d.getMonth()] + ', ' + d.getFullYear();

        var data = google.visualization.arrayToDataTable([
            ['Task', 'Hours per Day'],
            ['Treated', 1],
            ['cancelled', 1],
        ]);

        var options = {
            title: selectedMonthName + ' Appointment',
            pieHole: 0.4,
        };

        var chart = new google.visualization.PieChart(document.getElementById('donutchart'));
        chart.draw(data, options);
    }
</script>



<script type="text/javascript">
    google.charts.load('current', {'packages': ['corechart']});
    google.charts.setOnLoadCallback(drawVisualization);

    function drawVisualization() {
        // Some raw data (not necessarily accurate)
        var data = google.visualization.arrayToDataTable([
            ['Month', 'Income', 'Expense'],
            ['Jan', 0, 0],
            ['Feb', 0, 0],
            ['Mar', 0, 0],
            ['Apr', 0, 0],
            ['May', 0, 0],
            ['June', 0, 0],
            ['July', 0, 0],
            ['Aug', 0, 0],
            ['Sep', 0, 0],
            ['Oct', 7510, 5000],
            ['Nov', 0, 0],
            ['Dec', 0, 0],
        ]);

        var options = {
            title: new Date().getFullYear() + ' Per Month Income / Expense',
            vAxis: {title: '$'},
            hAxis: {title: 'Months'},
            seriesType: 'bars',
            series: {5: {type: 'line'}}
        };

        var chart = new google.visualization.ComboChart(document.getElementById('chart_div'));
        chart.draw(data, options);
    }
</script>

@endsection
