@extends('layouts.website.website')
@section('content')
    <!--main content start-->
    <section id="main-content">
        <section class="wrapper site-min-height">
            <!-- page start-->
            <section class="col-md-8">
                <header class="panel-heading">
                    Appointments
                </header>

                <div class="col-md-12">
                    <header class="panel-heading tab-bg-dark-navy-blueee row">
                        <ul class="nav nav-tabs col-md-8">
                            <li class="active">
                                <a data-toggle="tab" href="#calendardetails">Appointments Calendar</a>
                            </li>
                            <li class="">
                                <a data-toggle="tab" href="#list">Appointments</a>
                            </li>
                        </ul>

                        <div class="pull-right col-md-4">
                            <div class="pull-right custom_buttonss"></div>
                        </div>
                    </header>
                </div>

                <div class="">
                    <div class="tab-content">
                        <div id="calendardetails" class="tab-pane active">
                            <div class="">
                                <div class="panel-body">
                                    <div class="col-md-12">
                                        <aside class="calendar_ui col-md-12 panel calendar_ui">
                                            <section class="">
                                                <div class="">
                                                    <div id="calendarview" class="has-toolbar calendar_view"></div>
                                                </div>
                                            </section>
                                        </aside>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div id="list" class="tab-pane">
                            <div class="">
                                <div class="panel-body">
                                    <div class="adv-table editable-table">
                                        <div class="clearfix">
                                            <button class="export" onclick="javascript:window.print();">Print</button>
                                        </div>
                                        <div class="space15"></div>
                                        <table class="table table-striped table-hover table-bordered" id="editable-sample">
                                            <thead>
                                                <tr>
                                                    <th>Id</th>
                                                    <th>Patient</th>
                                                    <th>Date - Time</th>
                                                    <th>Remarks</th>
                                                    <th>Options</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <style>
                                                    .img_url {
                                                        height: 20px;
                                                        width: 20px;
                                                        background-size: contain;
                                                        max-height: 20px;
                                                        border-radius: 100px;
                                                    }
                                                </style>

                                                @foreach ($events as $item)
                                                    <tr class="">
                                                        <td>{{ $item->id }}</td>
                                                        <td>{{ $item->patient->name }}</td>
                                                        <td class="center">
                                                            {{ Carbon\Carbon::parse($item->appoinmen_date)->format('d,M y') }}
                                                            => {{ Carbon\Carbon::parse($item->start)->format('h:i a') }} To
                                                            {{ Carbon\Carbon::parse($item->end)->format('h:i a') }}</td>
                                                        <td>
                                                            Remarks
                                                        </td>
                                                        <td>
                                                            <!--
                                                                                    <button type="button" class="btn btn-info btn-xs btn_width editbutton" data-toggle="modal" data-id="489"><i class="fa fa-edit"> Edit</i></button>
                                                                                    -->
                                                            <a class="btn btn-info btn-xs btn_width delete_button"
                                                                href="{{ route('delete_doctor_appointment', $item->id) }}"
                                                                onclick="return confirm('Are you sure you want to delete this item?');">
                                                                <i class="fa fa-trash"> </i>
                                                            </a>
                                                        </td>
                                                    </tr>
                                                @endforeach

                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- page end-->

            <section class="col-md-4">
                <header class="panel-heading">
                    Doctor
                </header>

                <section class="">
                    <div class="panel-body profile">
                        <a href="#" class="task-thumb" style="margin-right: 10px;">
                            <img src="{{ asset('' . $doctor->photo) }}" height="100" width="100" />
                        </a>
                        <div class="task-thumb-details">
                            <h1><a href="#"> {{ $doctor->name }} </a></h1>
                            <p>{{ $doctor->doctor_profile }}</p>
                        </div>
                    </div>
                    <table class="table table-hover personal-task">
                        <tbody>
                            <tr>
                                <td>
                                    <i class="fa fa-envelope"></i>
                                </td>
                                <td>{{ $doctor->email }}</td>
                            </tr>
                            <tr>
                                <td>
                                    <i class="fa fa-phone"></i>
                                </td>
                                <td>{{ $doctor->phone }}</td>
                            </tr>
                        </tbody>
                    </table>
                </section>
            </section>
        </section>
    </section>
    <!--main content end-->

    <!-- Edit Event Modal-->
    <div class="modal fade" id="myModal2" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true"
        style="display: none;">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">�</button>
                    <h4 class="modal-title"><i class="fa fa-edit"></i> Edit Appointment</h4>
                </div>
                <div class="modal-body">
                    <form role="form" id="editAppointmentForm" action="appointment/addNew" method="post"
                        enctype="multipart/form-data">
                        <div class="form-group">
                            <div class="col-md-3">
                                <label for="exampleInputEmail1"> </label>
                            </div>
                            <div class="col-md-9">
                                <select class="form-control m-bot15" id="patientchoose1" name="patient" value="">
                                </select>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-3">
                                <label for="exampleInputEmail1"> Doctor</label>
                            </div>
                            <div class="col-md-9">
                                <select class="form-control m-bot15" id="doctorchoose1" name="doctor" value="">
                                </select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="exampleInputEmail1"> Date - Time</label>
                            <div data-date="" class="input-group date form_datetime-meridian">
                                <div class="input-group-btn">
                                    <button type="button" class="btn btn-info date-set"><i
                                            class="fa fa-calendar"></i></button>
                                    <button type="button" class="btn btn-danger date-reset"><i
                                            class="fa fa-times"></i></button>
                                </div>
                                <input type="text" class="form-control" readonly="" name="date"
                                    id="exampleInputEmail1" value="" placeholder="" />
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="exampleInputEmail1"> Remarks</label>
                            <input type="text" class="form-control" name="remarks" id="exampleInputEmail1"
                                value="" placeholder="" />
                        </div>

                        <input type="hidden" name="id" value="" />

                        <button type="submit" name="submit" class="btn btn-info">Submit</button>
                    </form>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <!-- Edit Event Modal-->
    <div class="modal fade" tabindex="-1" role="dialog" id="cmodal">
        <div class="modal-dialog modal-lg" role="document" style="width: 80%;">
            <div class="modal-content">
                <!--
                                            <div class="modal-header">
                                                <h5 class="modal-title">Patient History</h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            -->
                <div id="medical_history">
                    <div class="col-md-12"></div>
                </div>
                <div class="modal-footer">
                    <div class="col-md-12">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <script type="text/javascript">
        $(document).ready(function() {
            $(".table").on("click", ".editbutton", function() {
                //  e.preventDefault(e);
                // Get the record's ID via attribute
                var iid = $(this).attr("data-id");
                $("#editAppointmentForm").trigger("reset");
                $("#myModal2").modal("show");
                $.ajax({
                    url: "appointment/editAppointmentByJason?id=" + iid,
                    method: "GET",
                    data: "",
                    dataType: "json",
                }).success(function(response) {
                    // Populate the form fields with the data returned from server
                    $("#editAppointmentForm").find('[name="id"]').val(response.appointment.id)
                        .end();
                    //  $('#editAppointmentForm').find('[name="patient"]').val(response.appointment.patient).end()
                    //  $('#editAppointmentForm').find('[name="doctor"]').val(response.appointment.doctor).end()
                    $("#editAppointmentForm").find('[name="date"]').val(response.appointment.date)
                        .end();
                    $("#editAppointmentForm").find('[name="remarks"]').val(response.appointment
                        .remarks).end();
                    var option = new Option(response.patient.name + "-" + response.patient.id,
                        response.patient.id, true, true);
                    $("#editAppointmentForm").find('[name="patient"]').append(option).trigger(
                        "change");
                    var option1 = new Option(response.doctor.name + "-" + response.doctor.id,
                        response.doctor.id, true, true);
                    $("#editAppointmentForm").find('[name="doctor"]').append(option1).trigger(
                        "change");
                });
            });
        });
    </script>

    <script>
        $(document).ready(function() {
            $("#patientchoose").select2({
                placeholder: "Search Patient Name / ID",
                allowClear: true,
                ajax: {
                    url: "patient/getPatientinfo",
                    type: "post",
                    dataType: "json",
                    delay: 250,
                    data: function(params) {
                        return {
                            searchTerm: params.term, // search term
                        };
                    },
                    processResults: function(response) {
                        return {
                            results: response,
                        };
                    },
                    cache: true,
                },
            });
            $(".patientchoose1").select2({
                placeholder: "Search Patient Name / ID",
                allowClear: true,
                ajax: {
                    url: "patient/getPatientinfo",
                    type: "post",
                    dataType: "json",
                    delay: 250,
                    data: function(params) {
                        return {
                            searchTerm: params.term, // search term
                        };
                    },
                    processResults: function(response) {
                        return {
                            results: response,
                        };
                    },
                    cache: true,
                },
            });
            $("#doctorchoose").select2({
                placeholder: "Search Doctor Name / ID",
                allowClear: true,
                ajax: {
                    url: "doctor/getDoctorInfo",
                    type: "post",
                    dataType: "json",
                    delay: 250,
                    data: function(params) {
                        return {
                            searchTerm: params.term, // search term
                        };
                    },
                    processResults: function(response) {
                        return {
                            results: response,
                        };
                    },
                    cache: true,
                },
            });
            $("#doctorchoose1").select2({
                placeholder: "Search Doctor Name / ID",
                allowClear: true,
                ajax: {
                    url: "doctor/getDoctorInfo",
                    type: "post",
                    dataType: "json",
                    delay: 250,
                    data: function(params) {
                        return {
                            searchTerm: params.term, // search term
                        };
                    },
                    processResults: function(response) {
                        return {
                            results: response,
                        };
                    },
                    cache: true,
                },
            });
        });
    </script>
    <script src="{{ asset('contents/admin') }}/axios.js"></script>
    <script type="text/javascript">
        // $(document).ready(function () {
        //     $("#calendarview").fullCalendar({
        //         lang: "en",
        //         events: "appointment/getAppointmentByJasonByDoctor?id=" + 1,
        //         header: {
        //             left: "prev,next today",
        //             center: "title",
        //             right: "month,agendaWeek,agendaDay",
        //         },
        //         /*    timeFormat: {// for event elements
        //          'month': 'h:mm TT A {h:mm TT}', // default
        //          'week': 'h:mm TT A {h:mm TT}', // default
        //          'day': 'h:mm TT A {h:mm TT}'  // default
        //          },

        //          */
        //         timeFormat: "h(:mm) A",
        //         eventRender: function (event, element) {
        //             element.find(".fc-time").html(element.find(".fc-time").text());
        //             element.find(".fc-title").html(element.find(".fc-title").text());
        //         },
        //         eventClick: function (event) {
        //             $("#medical_history").html("");
        //             if (event.id) {
        //                 $.ajax({
        //                     url: "patient/getMedicalHistoryByJason?id=" + event.id + "&from_where=calendar",
        //                     method: "GET",
        //                     data: "",
        //                     dataType: "json",
        //                 }).success(function (response) {
        //                     // Populate the form fields with the data returned from server
        //                     $("#medical_history").html("");
        //                     $("#medical_history").append(response.view);
        //                 });
        //                 //alert(event.id);
        //             }

        //             $("#cmodal").modal("show");
        //         },
        //         slotDuration: "00:5:00",
        //         businessHours: false,
        //         slotEventOverlap: false,
        //         editable: false,
        //         selectable: false,
        //         lazyFetching: true,
        //         minTime: "6:00:00",
        //         maxTime: "24:00:00",
        //         defaultView: "month",
        //         allDayDefault: false,
        //         displayEventEnd: true,
        //         timezone: false,
        //     });
        // });
        $(document).ready(function() {
            var events = {!! json_encode($evnt_array) !!};
            console.log(events);
            $('#calendarview').fullCalendar({
                lang: 'en',
                events: events,
                header: {
                    left: 'prev,next today',
                    center: 'title',
                    right: 'month,agendaWeek,agendaDay',
                },

                /*    timeFormat: {// for event elements
                'month': 'h:mm TT A {h:mm TT}', // default
                'week': 'h:mm TT A {h:mm TT}', // default
                'day': 'h:mm TT A {h:mm TT}'  // default
                },

                */
                timeFormat: 'h(:mm) A',
                eventRender: function(event, element) {
                    element.find('.fc-time').html(element.find('.fc-time').text());
                    element.find('.fc-title').html(element.find('.fc-title').text());

                },
                eventClick: function(event) {
                    $('#medical_history').html("");
                    if (event.id) {
                        axios.get('/patient/getMedicalHistoryByJason/' + event.id)
                            .then(function(response) {
                                console.log(response);
                                $('#medical_history').html("");
                                $('#medical_history').append(response.data);
                                $('#cmodal').modal('show');
                            })
                        // $.ajax({
                        //     url: '/patient/getMedicalHistoryByJason/' + event.id ,
                        //     method: 'GET',
                        //     data: '',
                        //     dataType: 'json',
                        // }).success(function (response) {
                        //     // Populate the form fields with the data returned from server
                        //     console.log(response);
                        //     $('#medical_history').html("");
                        //     $('#medical_history').append(response);
                        // });
                        // alert(event.id);

                    }
                    console.log(event.id);

                },

                /*   eventMouseover: function (calEvent, domEvent) {
                var layer = "<div id='events-layer' class='fc-transparent' style='position:absolute; width:100%; height:100%; top:-1px; text-align:right; z-index:100'>Description</div>";
                $(this).append(layer);
                },

                eventMouseout: function (calEvent, domEvent) {
                $(this).append(layer);
                },

                */

                slotDuration: '00:5:00',
                businessHours: false,
                slotEventOverlap: false,
                editable: false,
                selectable: false,
                lazyFetching: true,
                minTime: "6:00:00",
                maxTime: "24:00:00",
                defaultView: 'month',
                allDayDefault: false,
                displayEventEnd: true,
                timezone: false,

            });
        });
    </script>
@endsection
