@extends('layouts.website.website')
@section('content')

    <!--main content start-->
<section id="main-content">
    <section class="wrapper site-min-height">
        <!-- page start-->
        <section class="">
            <header class="panel-heading">
                Pharmacy All Sales
                <div class="col-md-4 no-print pull-right">
                    <a href="finance/pharmacy/addPaymentView">
                        <div class="btn-group pull-right">
                            <button id="" class="btn green btn-xs"><i class="fa fa-plus-circle"></i> Add Sale</button>
                        </div>
                    </a>
                </div>
            </header>

            <style>
                .editable-table .search_form {
                    border: 0px solid #ccc !important;
                    padding: 0px !important;
                    background: none !important;
                    float: right;
                    margin-right: 14px !important;
                }

                .editable-table .search_form input {
                    padding: 6px !important;
                    width: 250px !important;
                    background: #fff !important;
                    border-radius: none !important;
                }

                .editable-table .search_row {
                    margin-bottom: 20px !important;
                }

                .panel-body {
                    padding: 15px 0px 15px 0px;
                }
            </style>

            <div class="panel-body">
                <div class="adv-table editable-table">
                    <div class="space15"></div>
                    <table class="table table-striped table-hover table-bordered" id="editable-sample1">
                        <thead>
                            <tr>
                                <th>Invoice Id</th>
                                <th>Date</th>
                                <th>Sub Total</th>
                                <th>Discount</th>
                                <th>Grand Total</th>
                                <!--
                                <th> Amount Received </th>
                                <th> Due Amount </th>
                                -->
                                <th class="option_th">Options</th>
                            </tr>
                        </thead>
                        <tbody>
                            <style>
                                .img_url {
                                    height: 20px;
                                    width: 20px;
                                    background-size: contain;
                                    max-height: 20px;
                                    border-radius: 100px;
                                }
                                .option_th {
                                    width: 18%;
                                }
                            </style>

                            @foreach (App\MadicineSale::latest()->get() as $item)


                                <tr role="row" class="odd">
                                    <td class="sorting_1 dtr-control">{{ $item->invoice_id }}</td>
                                    <td>{{ $item->created_at->format('d,M Y') }}</td>
                                    <td>{{ $item->sub_total }}</td>
                                    <td>{{ $item->discount }}</td>
                                    <td>{{ $item->grand_total }}</td>
                                    <td>
                                        <a class="btn btn-info btn-xs editbutton" href="{{ route('website_farmacy_addPaymentViewEdit',$item->id) }}"><i class="fa fa-edit"> </i> Edit</a>
                                        <a class="btn btn-xs green" style="color: #fff;" href="{{ route('website_farmacy_PaymentViewInvoice',$item->id) }}"><i class="fa fa-file-invoice"></i> Invoice</a>
                                        <a class="btn btn-info btn-xs invoicebutton" title="Print" style="color: #fff;" href="/pharmacy/printInvoice?id=1986" target="_blank"> <i class="fa fa-print"></i> Print</a>
                                        <a class="btn btn-info btn-xs btn_width delete_button" href="/pharmacy/delete?id=1986" onclick="return confirm('Are you sure you want to delete this item?');"><i class="fa fa-trash"> </i></a>
                                    </td>
                                </tr>

                            @endforeach


                        </tbody>
                    </table>
                </div>
            </div>
        </section>
        <!-- page end-->
    </section>
</section>
<!--main content end-->


@endsection
