@extends('layouts.website.website')
@section('content')
    <!--main content start-->
<section id="main-content">
    <section class="wrapper site-min-height">
        <!-- page start-->
        <section class="panel">
            <header class="panel-heading">
                Expense
                <div class="col-md-4 no-print pull-right">
                    <a href="/finance/addExpenseView">
                        <div class="btn-group pull-right">
                            <button id="" class="btn green btn-xs"><i class="fa fa-plus-circle"></i> Add Expense</button>
                        </div>
                    </a>
                </div>
            </header>
            <div class="panel-body">
                <div class="adv-table editable-table">
                    <div class="space15"></div>
                    <table class="table table-striped table-hover table-bordered" id="editable-sample">
                        <thead>
                            <tr>
                                <th>Category</th>
                                <th>Date</th>
                                <th>Note</th>
                                <th>Amount</th>
                                <th class="no-print">Options</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach (App\Expense::latest()->get() as $item)
                                <tr role="row" class="odd">
                                    <td class="sorting_1 dtr-control">{{ $item->categoryDetails->name }}</td>
                                    <td>{{ $item->created_at->format('d,M Y') }}</td>
                                    <td>{{ $item->description }}</td>
                                    <td>{{ $item->amount }}</td>
                                    <td>
                                        <a class="btn btn-info btn-xs editbutton" title="Edit" href="{{ route('website_expenseEdit',$item->id) }}"><i class="fa fa-edit"> </i></a>
                                        <a class="btn btn-info btn-xs delete_button" title="Delete" href="{{ route('website_expenseDelete',$item->id) }}" onclick="return confirm('Are you sure you want to delete this item?');">
                                            <i class="fa fa-trash"></i>
                                        </a>
                                        {{-- <a class="btn btn-info btn-xs invoicebutton" title="Invoice" style="color: #fff;" href="finance/expenseInvoice?id=89"><i class="fa fa-file-invoice"></i> </a> --}}
                                    </td>
                                </tr>
                            @endforeach

                            <style>
                                .img_url {
                                    height: 20px;
                                    width: 20px;
                                    background-size: contain;
                                    max-height: 20px;
                                    border-radius: 100px;
                                }
                            </style>
                        </tbody>
                    </table>
                </div>
            </div>
        </section>
        <!-- page end-->
    </section>
</section>
<!--main content end-->

@endsection
