@extends('layouts.website.website')
@section('content')
<!--main content start-->
<section id="main-content">
    <section class="wrapper site-min-height">
        <!-- page start-->
        <section class="panel">
            <header class="panel-heading">
                Appointment Calendar
            </header>
            <div class="panel-body">
                <aside>
                    <section class="panel">
                        <div class="panel-body">
                            <div id="calendar" class="has-toolbar calendar_view"></div>
                        </div>
                    </section>
                </aside>
            </div>
        </section>
        <!-- page end-->
    </section>
</section>

<!--main content end-->
<div class="modal fade" tabindex="-1" role="dialog" id="cmodal">
    <div class="modal-dialog modal-lg" role="document" style="width: 80%;">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Patient History</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div id="medical_history">
                <div class="col-md-12"></div>
            </div>
            <div class="modal-footer">
                <div class="col-md-12">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="{{ asset('contents/admin') }}/axios.js"></script>
<script type="text/javascript">

    $(document).ready(function () {
        var events = {!!json_encode($evnt_array)!!};
        console.log(events);
        $('#calendar').fullCalendar({
            lang: 'en',
            events: events,
            header:
                    {
                        left: 'prev,next today',
                        center: 'title',
                        right: 'month,agendaWeek,agendaDay',
                    },
            /*    timeFormat: {// for event elements
             'month': 'h:mm TT A {h:mm TT}', // default
             'week': 'h:mm TT A {h:mm TT}', // default
             'day': 'h:mm TT A {h:mm TT}'  // default
             },

             */
            timeFormat: 'h(:mm) A',
            eventRender: function (event, element) {
                element.find('.fc-time').html(element.find('.fc-time').text());
                element.find('.fc-title').html(element.find('.fc-title').text());

            },
            eventClick: function (event) {
                $('#medical_history').html("");
                if (event.id) {
                    // $.ajax({
                    //     url: 'patient/getMedicalHistoryByJason?id=' + event.id + '&from_where=calendar',
                    //     method: 'GET',
                    //     data: '',
                    //     dataType: 'json',
                    // }).success(function (response) {
                    //     // Populate the form fields with the data returned from server
                    //     $('#medical_history').html("");
                    //     $('#medical_history').append(response.view);
                    // });
                    //alert(event.id);

                    axios.get('/patient/getMedicalHistoryByJason/' + event.id)
                        .then(function(response){
                            console.log(response);
                            $('#medical_history').html("");
                            $('#medical_history').append(response.data);
                            $('#cmodal').modal('show');
                        })

                }

                $('#cmodal').modal('show');
            },

            /*   eventMouseover: function (calEvent, domEvent) {
             var layer = "<div id='events-layer' class='fc-transparent' style='position:absolute; width:100%; height:100%; top:-1px; text-align:right; z-index:100'>Description</div>";
             $(this).append(layer);
             },

             eventMouseout: function (calEvent, domEvent) {
             $(this).append(layer);
             },

             */

            slotDuration: '00:5:00',
            businessHours: false,
            slotEventOverlap: false,
            editable: false,
            selectable: false,
            lazyFetching: true,
            minTime: "6:00:00",
            maxTime: "24:00:00",
            defaultView: 'month',
            allDayDefault: false,
            displayEventEnd: true,
            timezone: false,

        });
    });

</script>

@endsection
