@extends('layouts.website.website')
@section('content')
    <!--main content start-->
    <section id="main-content">
        <section class="wrapper site-min-height">
            <!-- page start-->
            <section class="panel">
                <header class="panel-heading">
                    Blood Bank
                    <div class="col-md-4 pull-right">
                        <div class="pull-right"></div>
                    </div>
                </header>
                <div class="panel-body">
                    <div class="adv-table editable-table">
                        <div class="clearfix"></div>
                        <button class="export" onclick="javascript:window.print();">Print</button>
                        <div class="space15"></div>
                        <table class="table table-striped table-hover table-bordered" id="editable-sample">
                            <thead>
                                <tr>
                                    <th>Blood Group</th>
                                    <th>Status</th>
                                    <th>Options</th>
                                </tr>
                            </thead>
                            <tbody>
                                <style>
                                    .img_url {
                                        height: 20px;
                                        width: 20px;
                                        background-size: contain;
                                        max-height: 20px;
                                        border-radius: 100px;
                                    }
                                </style>
                                @foreach (App\BloodBank::get() as $item)
                                    <tr class="">
                                        <td>{{ $item->group }}</td>
                                        <td>{{ $item->amount }} Bags</td>
                                        <td>
                                            <button type="button" class="btn btn-info btn-xs btn_width editbutton" title="Edit" data-toggle="modal" data-id="{{ $item->id }}"><i class="fa fa-edit"></i></button>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </section>
            <!-- page end-->
        </section>
    </section>
    <!--main content end-->
    <!--footer start-->

    <!-- Edit Event Modal-->
    <div class="modal fade" id="myModal2" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                    <h4 class="modal-title">Update Blood Bank</h4>
                </div>
                <div class="modal-body">
                    <form role="form" id="editBloodBank" action="{{ route('update_bloodBank') }}" method="post" enctype="multipart/form-data">
                        @csrf
                        <div class="form-group">
                            <label for="exampleInputEmail1">Group</label>
                            <input type="text" class="form-control" name="group" id="exampleInputEmail1" value="" placeholder="" disabled />
                        </div>
                        <div class="form-group">
                            <label for="exampleInputEmail1">Status</label>
                            <input type="text" class="form-control" name="status" id="exampleInputEmail1" value="" placeholder="" />
                        </div>
                        <input type="hidden" name="id" value="" />
                        <button type="submit" name="submit" class="btn btn-info">Submit</button>
                    </form>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <!-- Edit Event Modal-->

    <script type="text/javascript">
        $(document).ready(function () {
            $(".editbutton").click(function (e) {
                e.preventDefault(e);
                // Get the record's ID via attribute
                var iid = $(this).attr("data-id");
                $("#editBloodBank").trigger("reset");
                $("#myModal2").modal("show");
                $.ajax({
                    url: "/donor/bloodBank/edit/" + iid,
                    method: "GET",
                    data: "",
                    dataType: "json",
                }).success(function (response) {
                    // Populate the form fields with the data returned from server
                    $("#editBloodBank").find('[name="id"]').val(response.id).end();
                    $("#editBloodBank").find('[name="group"]').val(response.group).end();
                    $("#editBloodBank").find('[name="status"]').val(response.amount).end();
                });
            });
        });
    </script>
    

@endsection
