@extends('layouts.website.website')
@section('content')

    <!--main content start-->
<section id="main-content">
    <section class="wrapper site-min-height">
        <!-- page start-->
        <section class="panel">
            <header class="panel-heading">
                Bed Categories
                <div class="col-md-4 no-print pull-right">
                    <a data-toggle="modal" href="#myModal">
                        <div class="btn-group pull-right">
                            <button id="" class="btn green btn-xs"><i class="fa fa-plus-circle"></i> Add New</button>
                        </div>
                    </a>
                </div>
            </header>
            <div class="panel-body">
                <div class="adv-table editable-table">
                    <div class="space15"></div>
                    <table class="table table-striped table-hover table-bordered" id="editable-sample">
                        <thead>
                            <tr>
                                <th>Category</th>
                                <th>Description</th>
                                <th class="no-print">Options</th>
                            </tr>
                        </thead>
                        <tbody>
                            <style>
                                .img_url {
                                    height: 20px;
                                    width: 20px;
                                    background-size: contain;
                                    max-height: 20px;
                                    border-radius: 100px;
                                }
                            </style>

                            @foreach (App\BedCategory::latest()->get() as $item)
                                <tr class="">
                                    <td>{{ $item->name }}</td>
                                    <td>{{ $item->description }}</td>
                                    <td class="no-print">
                                        <button type="button" title="Edit" class="btn btn-info btn-xs btn_width editbutton" data-toggle="modal" data-id="{{ $item->id }}"><i class="fa fa-edit"></i></button>
                                        <a class="btn btn-info btn-xs btn_width delete_button" title="Delete" href="{{ route('website_bedCategoryDelete',$item->id) }}" onclick="return confirm('Are you sure you want to delete this item?');">
                                            <i class="fa fa-trash"></i>
                                        </a>
                                    </td>
                                </tr>
                            @endforeach

                        </tbody>
                    </table>
                </div>
            </div>
        </section>
        <!-- page end-->
    </section>
</section>
<!--main content end-->
<!--footer start-->

<!-- Add Accountant Modal-->
<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title">Add Bed Category</h4>
            </div>
            <div class="modal-body">
                <form role="form" action="{{ route('website_bedCategoryStore') }}" class="clearfix row" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="form-group col-md-12">
                        <label for="exampleInputEmail1">Category</label>
                        <input type="text" class="form-control" name="name" id="exampleInputEmail1" value="" placeholder="" />
                    </div>
                    <div class="form-group col-md-12">
                        <label for="exampleInputEmail1">Description</label>
                        <input type="text" class="form-control" name="description" id="exampleInputEmail1" value="" placeholder="" />
                    </div>
                    <div class="form-group col-md-12">
                        <button type="submit" name="submit" class="btn btn-info pull-right">Submit</button>
                    </div>
                </form>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- Add Accountant Modal-->

<!-- Edit Event Modal-->
<div class="modal fade" id="myModal2" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title">Edit Bed Category</h4>
            </div>
            <div class="modal-body">
                <form role="form" id="editBedCategoryForm" class="clearfix row" action="{{ route('website_bedCategoryUpdate') }}" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="form-group col-md-12">
                        <label for="exampleInputEmail1">Category</label>
                        <input type="text" class="form-control" name="name" id="exampleInputEmail1" value="" placeholder="" />
                    </div>
                    <div class="form-group col-md-12">
                        <label for="exampleInputEmail1">Description</label>
                        <input type="text" class="form-control" name="description" id="exampleInputEmail1" value="" placeholder="" />
                    </div>

                    <input type="hidden" name="id" value="" />

                    <div class="form-group col-md-12">
                        <button type="submit" name="submit" class="btn btn-info pull-right">Submit</button>
                    </div>
                </form>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- Edit Event Modal-->


    <script type="text/javascript">
        $(document).ready(function () {
            $(".editbutton").click(function (e) {
                e.preventDefault(e);
                // Get the record's ID via attribute
                var iid = $(this).attr("data-id");
                $("#editBedCategoryForm").trigger("reset");
                $("#myModal2").modal("show");
                $.ajax({
                    url: "/bed/bedCategoryEdit/" + iid,
                    method: "GET",
                    data: "",
                    dataType: "json",
                }).success(function (response) {
                    // Populate the form fields with the data returned from server
                    $("#editBedCategoryForm").find('[name="id"]').val(response.id).end();
                    $("#editBedCategoryForm").find('[name="name"]').val(response.name).end();
                    $("#editBedCategoryForm").find('[name="description"]').val(response.description).end();
                });
            });
        });
    </script>


@endsection
