@extends('layouts.website.website')
@section('content')
    <!--main content start-->
<section id="main-content">
    <section class="wrapper site-min-height">
        <!-- page start-->
        <section class="panel">
            <header class="panel-heading">
                Alloted Beds
                <div class="col-md-4 no-print pull-right">
                    <a data-toggle="modal" href="#myModal">
                        <div class="btn-group pull-right">
                            <button id="" class="btn green btn-xs"><i class="fa fa-plus-circle"></i> Add New Allotment</button>
                        </div>
                    </a>
                </div>
            </header>
            <div class="panel-body">
                <div class="adv-table editable-table">
                    <div class="space15"></div>
                    <table class="table table-striped table-hover table-bordered" id="editable-sample">
                        <thead>
                            <tr>
                                <th>Bed Id</th>
                                <th>Patient</th>
                                <th>Alloted Time</th>
                                <th>Discharge Time</th>
                                <th class="no-print">Options</th>
                            </tr>
                        </thead>
                        <tbody>

                            @foreach (App\BedAllotment::latest()->get() as $item)
                                <tr role="row" class="odd">
                                    <td class="sorting_1 dtr-control">{{ $item->bed_info->category->name }}-Bed {{ $item->id }}</td>
                                    <td>{{ $item->user->name }}</td>
                                    <td>{{ Carbon\Carbon::parse($item->alloted_time)->format('d,M Y') }}</td>
                                    <td>{{ Carbon\Carbon::parse($item->discharge_time)->format('d,M Y') }}</td>
                                    <td>
                                        <button type="button" class="btn btn-info btn-xs btn_width editbutton" data-toggle="modal" data-id="{{ $item->id }}"><i class="fa fa-edit"> </i> Edit</button>
                                        <a class="btn btn-info btn-xs btn_width delete_button" href="{{ route('website_bedAllotmentDelete',$item->id) }}" onclick="return confirm('Are you sure you want to delete this item?');"><i class="fa fa-trash"> </i> Delete</a>
                                    </td>
                                </tr>
                            @endforeach

                            <style>
                                .img_url {
                                    height: 20px;
                                    width: 20px;
                                    background-size: contain;
                                    max-height: 20px;
                                    border-radius: 100px;
                                }
                            </style>
                        </tbody>
                    </table>
                </div>
            </div>
        </section>
        <!-- page end-->
    </section>
</section>
<!--main content end-->
<!--footer start-->

<!-- Add Accountant Modal-->
<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title">Add New Allotment</h4>
            </div>
            <div class="modal-body">
                <form role="form" action="{{ route('website_bedAllotmentStore') }}" class="clearfix row" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="form-group col-md-12">
                        <label for="exampleInputEmail1">Bed Id</label>
                        <select class="form-control m-bot15 select2" name="bed_id" value="">
                            @foreach (App\Bed::orderBy('bed_category','ASC')->get() as $item)
                                <option value="{{ $item->id }}">{{ $item->category->name }}-bed {{ $item->id }} </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group col-md-12">
                        <label for="exampleInputEmail1">Patient</label>
                        <select class="form-control m-bot15 select2" name="patient_id" value="">
                            @foreach (App\User::where('role_id',8)->get() as $item)
                                <option value="{{ $item->id }}">{{ $item->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group col-md-12">
                        <label for="exampleInputEmail1">Alloted Time</label>
                        <div data-date="" class="input-group ">
                            <input type="date" class="form-control" name="alloted_time" value="" placeholder="" />
                        </div>
                    </div>

                    <div class="form-group col-md-12">
                        <label for="exampleInputEmail1">Discharge Time</label>
                        <div data-date="" class="input-group  ">
                            <input type="date" class="form-control" name="discharge_time"  value="" placeholder="" />
                        </div>
                    </div>

                    <input type="hidden" name="id" value="" />

                    <div class="form-group col-md-12">
                        <button type="submit" name="submit" class="btn btn-info pull-right">Submit</button>
                    </div>
                </form>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- Add Accountant Modal-->

<!-- Edit Event Modal-->
<div class="modal fade" id="myModal2" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title">Edit Allotment</h4>
            </div>
            <div class="modal-body">
                <form role="form" id="editAllotmentForm" action="{{ route('website_bedAllotmentUpdate') }}" class="clearfix row" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="form-group col-md-12">
                        <label for="exampleInputEmail1">Bed Id</label>
                        <select class="form-control m-bot15 select2" name="bed_id" value="">
                            @foreach (App\Bed::orderBy('bed_category','ASC')->get() as $item)
                                <option value="{{ $item->id }}">{{ $item->category->name }}-bed {{ $item->id }} </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group col-md-12">
                        <label for="exampleInputEmail1">Patient</label>
                        <select class="form-control m-bot15 select2" name="patient_id" value="">
                            @foreach (App\User::where('role_id',8)->get() as $item)
                                <option value="{{ $item->id }}">{{ $item->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group col-md-12">
                        <label for="exampleInputEmail1">Alloted Time</label>
                        <div data-date="" class="input-group ">
                            <input type="date" class="form-control" name="alloted_time" value="" placeholder="" />
                        </div>
                    </div>

                    <div class="form-group col-md-12">
                        <label for="exampleInputEmail1">Discharge Time</label>
                        <div data-date="" class="input-group  ">
                            <input type="date" class="form-control" name="discharge_time"  value="" placeholder="" />
                        </div>
                    </div>

                    <input type="hidden" name="id" value="" />

                    <div class="form-group col-md-12">
                        <button type="submit" name="submit" class="btn btn-info pull-right">Submit</button>
                    </div>
                </form>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- Edit Event Modal-->

<script type="text/javascript">
    $(document).ready(function () {
        $(".table").on("click", ".editbutton", function () {
            //   e.preventDefault(e);
            // Get the record's ID via attribute
            var iid = $(this).attr("data-id");
            $("#editAllotmentForm").trigger("reset");
            $("#myModal2").modal("show");
            $.ajax({
                url: "/bed/bedAllotmentEdit/" + iid,
                method: "GET",
                data: "",
                dataType: "json",
            }).success(function (response) {
                // Populate the form fields with the data returned from server
                $("#editAllotmentForm").find('[name="id"]').val(response.id).end();
                $("#editAllotmentForm").find('[name="bed_id"]').val(response.bed_id).trigger('change');
                //  $('#editAllotmentForm').find('[name="patient"]').val(response.allotment.patient).end()
                // var option = new Option(response.patient.name + "-" + response.patient.id, response.patient.id, true, true);
                $("#editAllotmentForm").find('[name="patient_id"]').val(response.patient_id).trigger("change");
                $("#editAllotmentForm").find('[name="alloted_time"]').val(response.alloted_time).end();
                $("#editAllotmentForm").find('[name="discharge_time"]').val(response.discharge_time).end();
            });
        });
    });
</script>


@endsection
