@extends('layouts.website.website')
@section('content')
    <!--main content start-->
<section id="main-content">
    <section class="wrapper site-min-height">
        <!-- page start-->
        <section class="panel">
            <header class="panel-heading">
                Bed
                <div class="col-md-4 no-print pull-right">
                    <a data-toggle="modal" href="#myBedModal">
                        <div class="btn-group pull-right">
                            <button id="" class="btn green btn-xs"><i class="fa fa-plus-circle"></i> Add New</button>
                        </div>
                    </a>
                </div>
            </header>
            <div class="panel-body">
                <div class="adv-table editable-table">
                    <div class="space15"></div>
                    <table class="table table-striped table-hover table-bordered" id="editable-sample">
                        <thead>
                            <tr>
                                <th>Bed Id</th>
                                <th>Description</th>
                                <th>Status</th>
                                <th class="no-print">Options</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach (App\Bed::orderBy('bed_category','ASC')->get() as $item)

                                <tr role="row" class="odd">
                                    <td class="sorting_1 dtr-control">{{ $item->category->name }}-Bed {{ $item->number }}</td>
                                    <td>{{ $item->description }}</td>
                                    <td>
                                        @if ($item->status == 1)
                                            <button type="button" class="btn btn-success">Available</button>
                                        @endif
                                        @if ($item->status == 2)
                                            <button type="button" class="btn btn-success">Alloted</button>
                                        @endif
                                    </td>
                                    <td>
                                        <button type="button" class="btn btn-info btn-xs btn_width editbutton" data-toggle="modal" data-id="{{ $item->id }}"><i class="fa fa-edit"> </i> Edit</button>
                                        <a class="btn btn-info btn-xs btn_width delete_button" href="{{ route('website_bedDelete',$item->id) }}" onclick="return confirm('Are you sure you want to delete this item?');"><i class="fa fa-trash"> </i> Delete</a>
                                    </td>
                                </tr>

                            @endforeach


                            <style>
                                .img_url {
                                    height: 20px;
                                    width: 20px;
                                    background-size: contain;
                                    max-height: 20px;
                                    border-radius: 100px;
                                }
                            </style>
                        </tbody>
                    </table>
                </div>
            </div>
        </section>
        <!-- page end-->
    </section>
</section>
<!--main content end-->
<!--footer start-->

<!-- Add Bed Modal-->
<div class="modal fade" id="myBedModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title">Add New Bed</h4>
            </div>
            <div class="modal-body">
                <form role="form" action="{{ route('website_bedStore') }}" class="clearfix row" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="form-group col-md-12">
                        <label for="exampleInputEmail1">Bed Category</label>
                        <select class="form-control select2" name="bed_category" value="">
                            <option value="Category"> Category </option>
                            @foreach (App\BedCategory::latest()->get() as $item)
                                <option value="{{ $item->id }}">{{ $item->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group col-md-12">
                        <label for="exampleInputEmail1">Bed Number</label>
                        <input type="text" class="form-control" name="number" id="exampleInputEmail1" value="" placeholder="" />
                    </div>
                    <div class="form-group col-md-12">
                        <label for="exampleInputEmail1">Description</label>
                        <input type="text" class="form-control" name="description" id="exampleInputEmail1" value="" placeholder="" />
                    </div>

                    <div class="form-group col-md-12">
                        <button type="submit" name="submit" class="btn btn-info pull-right">Submit</button>
                    </div>
                </form>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- Add Accountant Modal-->

<!-- Edit Event Modal-->
<div class="modal fade" id="myModal2" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title">Edit Bed</h4>
            </div>
            <div class="modal-body">
                <form role="form" id="editBedForm" class="clearfix row" action="{{ route('website_bedUpdate') }}" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="form-group col-md-12">
                        <label for="exampleInputEmail1">Bed Category</label>
                        <select class="form-control select2" name="bed_category" value="">
                            @foreach (App\BedCategory::latest()->get() as $item)
                                <option value="{{ $item->id }}">{{ $item->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group col-md-12">
                        <label for="exampleInputEmail1">Bed Number</label>
                        <input type="text" class="form-control" name="number" id="exampleInputEmail1" value="" placeholder="" />
                    </div>
                    <div class="form-group col-md-12">
                        <label for="exampleInputEmail1">Description</label>
                        <input type="text" class="form-control" name="description" id="exampleInputEmail1" value="" placeholder="" />
                    </div>

                    <input type="hidden" name="id" value="" />

                    <div class="form-group col-md-12">
                        <button type="submit" name="submit" class="btn btn-info pull-right">Submit</button>
                    </div>
                </form>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- Edit Event Modal-->

<script src="common/js/codearistos.min.js"></script>
<script type="text/javascript">
    $(document).ready(function () {
        $(".table").on("click", ".editbutton", function () {
            // e.preventDefault(e);
            // Get the record's ID via attribute
            var iid = $(this).attr("data-id");
            $("#editBedForm").trigger("reset");
            $("#myModal2").modal("show");
            $.ajax({
                url: "/bed/bedEdit/" + iid,
                method: "GET",
                data: "",
                dataType: "json",
            }).success(function (response) {
                // Populate the form fields with the data returned from server
                $("#editBedForm").find('[name="id"]').val(response.id).end();
                $("#editBedForm").find('[name="bed_category"]').val(response.bed_category).trigger('change');
                $("#editBedForm").find('[name="number"]').val(response.number).end();
                $("#editBedForm").find('[name="description"]').val(response.description).end();
            });
        });
    });
</script>

@endsection
