@extends('layouts.website.website')
@section('content')
<!--main content start-->
<section id="main-content">
    <section class="wrapper site-min-height row">
        <!-- page start-->
        <section class="col-md-6">
            <header class="panel-heading">
                Add Expense
            </header>
            <div class="panel-body">
                <div class="adv-table editable-table">
                    <div class="clearfix">
                        <form role="form" action="{{ route('website_updateExpense') }}" class="clearfix row" method="post" enctype="multipart/form-data">
                            @csrf
                            <div class="form-group col-md-12">
                                <label for="exampleInputEmail1">Category</label>
                                <select class="form-control m-bot15 select2" name="category" value="">
                                    @foreach (App\ExpenseCategory::get() as $item)
                                        <option value="{{ $item->id }}"> {{ $item->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group col-md-12">
                                <label for="exampleInputEmail1">Amount</label>
                                <input type="text" class="form-control" name="amount" id="exampleInputEmail1" value="{{ $expense->amount }}" placeholder="$" />
                            </div>
                            <div class="form-group col-md-12">
                                <label for="exampleInputEmail1">Note</label>
                                <input type="text" class="form-control" name="description" id="exampleInputEmail1" value="{{ $expense->description }}" placeholder="" />
                            </div>
                            <input type="hidden" name="id" value="{{ $expense->id }}" />
                            <div class="form-group col-md-12">
                                <button type="submit" name="submit" class="btn btn-info pull-right">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </section>
        <!-- page end-->
    </section>
</section>
<!--main content end-->

@endsection
