<?php

namespace App;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    use Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'phone', 'role_id', 'address', 'password','slug',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function role(){
        return $this->belongsTo('App\UserRole','role_id','role_serial');
    }
    public function department(){
        return $this->belongsTo('App\Department','doctor_department','id');
    }
    public function patients_doctor(){
        return $this->belongsTo('App\User','patient_doctor','id');
    }
    public function doctor_schedule(){
        return $this->hasMany('App\DoctorSchedule','doctor_id','id');
    }
    public function time_schedule()
    {
        return $this->hasMany('App\DoctorScheduleDayTime','doctor_id','id');
    }
}
