<?php

namespace App\Http\Controllers\Hms;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Report;
use Illuminate\Support\Facades\Auth;

class ReportController extends Controller
{
    public function report_birth(Request $request)
    {
        $reports = Report::where('type','birth')->latest()->get();
        return view('hms.report',compact('reports'));
    }
    public function report_operation(Request $request)
    {
        $reports = Report::where('type','operation')->latest()->get();
        return view('hms.report',compact('reports'));
    }
    public function report_expire(Request $request)
    {
        $reports = Report::where('type','birth')->latest()->get();
        return view('hms.report',compact('reports'));
    }

    public function store_report(Request $request){
        $this->validate($request,[
            'description' => ['required']
        ]);

        $report = new Report();
        $report->type = $request->type;
        $report->description = $request->description;
        $report->patient_id = $request->patient;
        $report->doctor_id = $request->doctor;
        $report->date = $request->date;
        $report->creator = Auth::user()->id;
        $report->save();
        $report->slug =  $report->id.'_'.uniqid(10);
        $report->save();

        return redirect()->back()->with('success','new report added');
    }

    public function update_report(Request $request){
        // dd($request->request);
        $this->validate($request,[
            'description' => ['required']
        ]);

        $report = Report::find($request->id);
        $report->type = $request->type;
        $report->description = $request->description;
        $report->patient_id = $request->patient;
        $report->doctor_id = $request->doctor;
        $report->date = $request->date;
        $report->creator = Auth::user()->id;
        $report->save();

        return redirect()->back()->with('success','report updated');
    }

    public function edit(Request $request,$id){
        $report = Report::find($id);
        return response()->json($report);
    }

    public function delete(Request $request,$id){
        $report = Report::find($id);
        $report->delete();
        return redirect()->back()->with('success','report deleted');
    }
}
