<?php

namespace App\Http\Controllers\Hms;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;
use App\MadicineCategory;
use App\MadicneList;

class MadicineController extends Controller
{
    public function medicine(Request $request)
    {
        return view('hms.medicine');
    }

    public function addMedicineView(Request $request)
    {
        return view('hms.addMedicineView');
    }
    public function medicineCategory(Request $request)
    {
        return view('hms.medicineCategory');
    }

    public function addCategoryView(Request $request)
    {
        return view('hms.addCategoryView');
    }
    public function medicineStockAlert(Request $request)
    {
        return view('hms.medicineStockAlert');
    }

    public function medicineStore(Request $request){
        // dd($request->request);
        $medicine = new MadicneList();
        $medicine->name = $request->name;
        $medicine->category_id = $request->category_id;
        $medicine->price = $request->price;
        $medicine->saleprice = $request->saleprice;
        $medicine->storebox = $request->storebox;
        $medicine->quantity = $request->quantity;
        $medicine->genericname = $request->genericname;
        $medicine->company = $request->company;
        $medicine->effect = $request->effect;
        $medicine->expire_date = $request->expire_date;
        $medicine->creator = Auth::user()->id;
        $medicine->created_at = Carbon::now()->toDateTimeString();
        $medicine->save();
        $medicine->slug = $medicine->id.'_'.uniqid(10);
        $medicine->save();
        return redirect()->back()->with('success','new medicine store.');
    }

    public function medicineEdit(Request $request,$id){
        $medicine = MadicneList::find($id);
        return response()->json($medicine);
    }

    public function medicineDelete(Request $request,$id){
        $medicine = MadicneList::find($id);
        $medicine->delete();
        return redirect()->back()->with('success','medicine deleted.');
    }

    public function medicineUpdate(Request $request){
        $medicine = MadicneList::find($request->id);
        $medicine->name = $request->name;
        $medicine->category_id = $request->category_id;
        $medicine->price = $request->price;
        $medicine->saleprice = $request->saleprice;
        $medicine->storebox = $request->storebox;
        $medicine->quantity = $request->quantity;
        $medicine->genericname = $request->genericname;
        $medicine->company = $request->company;
        $medicine->effect = $request->effect;
        $medicine->expire_date = $request->expire_date;
        $medicine->creator = Auth::user()->id;
        $medicine->updated_at = Carbon::now()->toDateTimeString();
        $medicine->save();
        return redirect()->back()->with('success','new medicine update.');
    }

    public function medicineQtyUpdate(Request $request){
        $medicine = MadicneList::find($request->id);
        $medicine->quantity = $request->qty;
        $medicine->creator = Auth::user()->id;
        $medicine->save();
        return redirect()->back()->with('success','medicine quantity updated.');
    }

    public function medicineCategoryStore(Request $request){
        $medicineCategory = new MadicineCategory();
        $medicineCategory->name = $request->name;
        $medicineCategory->description = $request->description;
        $medicineCategory->creator = Auth::user()->id;
        $medicineCategory->created_at = Carbon::now()->toDateTimeString();
        $medicineCategory->save();
        $medicineCategory->slug = $medicineCategory->id.'_'.uniqid(10);
        $medicineCategory->save();
        return redirect()->back()->with('success','new medicine category added.');
    }

    public function medicineCategoryEdit(Request $request,$id){
        $medicineCategory = MadicineCategory::find($id);
        return response()->json($medicineCategory);
    }

    public function medicineCategoryUpdate(Request $request){
        $medicineCategory = MadicineCategory::find($request->id);
        $medicineCategory->name = $request->name;
        $medicineCategory->description = $request->description;
        $medicineCategory->creator = Auth::user()->id;
        $medicineCategory->updated_at = Carbon::now()->toDateTimeString();
        $medicineCategory->save();
        return redirect()->back()->with('success','medicine category updated.');
    }

    public function medicineCategoryDelete(Request $request,$id){
        $medicineCategory = MadicineCategory::find($id);
        $medicineCategory->delete();
        return redirect()->back()->with('success','medicine category deleted.');
    }
}
