<?php

namespace App\Http\Controllers\Hms;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\BloodDonor;
use Illuminate\Support\Facades\Auth;
use App\BloodBank;

class DonorController extends Controller
{
    public function donor(Request $request)
    {
        return view('hms.donor');
    }
    public function addDonorView(Request $request)
    {
        return view('hms.addDonorView');
    }
    public function bloodBank(Request $request)
    {
        return view('hms.bloodBank');
    }

    public function store_donor(Request $request){
        // dd($request->request);

        $this->validate($request,[
            'name' => ['required'],
            'age' => ['required'],
            'ldd' => ['required'],
            'name' => ['required'],
        ]);

        $donor = new BloodDonor();
        $donor->name = $request->name;
        $donor->blood_group = $request->group;
        $donor->age = $request->age;
        $donor->last_donation_date = $request->ldd;
        $donor->phone = $request->phone;
        $donor->sex = $request->sex;
        $donor->email = $request->email;
        $donor->creator = Auth::user()->id;
        $donor->save();
        $donor->slug = $donor->id.'_'.uniqid(10);
        $donor->save();
        return redirect()->back()->with('success','new dono added successfully.');
    }

    public function update_donor(Request $request){
        // dd($request->request);

        $this->validate($request,[
            'name' => ['required'],
            'age' => ['required'],
            'ldd' => ['required'],
            'name' => ['required'],
        ]);

        $donor = BloodDonor::find($request->id);
        $donor->name = $request->name;
        $donor->blood_group = $request->group;
        $donor->age = $request->age;
        $donor->last_donation_date = $request->ldd;
        $donor->phone = $request->phone;
        $donor->sex = $request->sex;
        $donor->email = $request->email;
        $donor->creator = Auth::user()->id;
        $donor->save();
        return redirect()->back()->with('success','donor updated successfully.');
    }

    public function bloodBankupdate(Request $request){
        $bank = BloodBank::find($request->id);
        $bank->amount = $request->status;
        $bank->creator = Auth::user()->id;
        $bank->save();
        return redirect()->back()->with('success','Blood Bank updated successfully.');
    }

    public function edit(Request $request,$id){
        $donor = BloodDonor::find($id);
        return response()->json($donor);
    }

    public function bloodBankedit(Request $request,$id){
        $donor = BloodBank::find($id);
        return response()->json($donor);
    }

    public function delete(Request $request,$id){
        $donor = BloodDonor::find($id);
        $donor->delete();
        return redirect()->back()->with('success','donor deleted successfully.');
    }
}
