<?php

namespace App\Http\Controllers\Hms;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\BedCategory;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;
use App\Bed;
use App\BedAllotment;

class BedController extends Controller
{
    public function bed(Request $request)
    {
        return view('hms.bed');
    }
    public function addBedView(Request $request)
    {
        return view('hms.addBedView');
    }
    public function bedCategory(Request $request)
    {
        return view('hms.bedCategory');
    }
    public function bedAllotment(Request $request)
    {
        return view('hms.bedAllotment');
    }
    public function addAllotmentView(Request $request)
    {
        return view('hms.addAllotmentView');
    }

    public function bedAllotmentStore(Request $request){
        $allotment = new BedAllotment();
        $allotment->bed_id = $request->bed_id;
        $allotment->patient_id = $request->patient_id;
        $allotment->alloted_time = $request->alloted_time;
        $allotment->discharge_time = $request->discharge_time;
        $allotment->creator = Auth::user()->id;
        $allotment->created_at = Carbon::now()->toDateTimeString();
        $allotment->save();
        $allotment->slug = $allotment->id.'_'.uniqid(10);
        $allotment->save();

        return redirect()->back()->with('success','new allotment inserted.');
    }

    public function bedAllotmentUpdate(Request $request){
        $allotment = BedAllotment::find($request->id);
        $allotment->bed_id = $request->bed_id;
        $allotment->patient_id = $request->patient_id;
        $allotment->alloted_time = $request->alloted_time;
        $allotment->discharge_time = $request->discharge_time;
        $allotment->creator = Auth::user()->id;
        $allotment->updated_at = Carbon::now()->toDateTimeString();
        $allotment->save();

        return redirect()->back()->with('success','allotment updated.');
    }

    public function bedAllotmentEdit(Request $request,$id){
        $allotment = BedAllotment::find($id);
        return response()->json($allotment);
    }

    public function bedAllotmentDelete(Request $request,$id){
        $allotment = BedAllotment::find($id);
        $allotment->delete();
        return redirect()->back()->with('success','allotment deleted.');
    }

    public function bedStore(Request $request){
        $bed = new Bed();
        $bed->bed_category = $request->bed_category;
        $bed->number = $request->number;
        $bed->description = $request->description;
        $bed->creator = Auth::user()->id;
        $bed->created_at = Carbon::now()->toDateTimeString();
        $bed->save();
        $bed->slug = $bed->id.'_'.uniqid(10);
        $bed->save();
        return redirect()->back()->with('success','new bed inserted.');
    }
    public function bedUpdated(Request $request){
        $bed = Bed::find($request->id);
        $bed->bed_category = $request->bed_category;
        $bed->number = $request->number;
        $bed->description = $request->description;
        $bed->creator = Auth::user()->id;
        $bed->updated_at = Carbon::now()->toDateTimeString();
        $bed->save();
        return redirect()->back()->with('success','bed updated.');
    }

    public function bedEdit(Request $request,$id){
        $bed = Bed::find($id);
        return response()->json($bed);
    }
    public function bedDelete(Request $request,$id){
        $bed = Bed::find($id);
        $bed->delete();
        return redirect()->back()->with('success','bed Deleted.');
    }

    public function bedCategoryStore(Request $request){
        $bedCategory = new BedCategory();
        $bedCategory->name = $request->name;
        $bedCategory->description = $request->description;
        $bedCategory->creator = Auth::user()->id;
        $bedCategory->created_at = Carbon::now()->toDateTimeString();
        $bedCategory->save();
        $bedCategory->slug = $bedCategory->id.'_'.uniqid(10);
        $bedCategory->save();

        return redirect()->back()->with('success','Bed Category inserted.');
    }

    public function bedCategoryUpdate(Request $request){
        $bedCategory = BedCategory::find($request->id);
        $bedCategory->name = $request->name;
        $bedCategory->description = $request->description;
        $bedCategory->creator = Auth::user()->id;
        $bedCategory->updated_at = Carbon::now()->toDateTimeString();
        $bedCategory->save();

        return redirect()->back()->with('success','Bed Category updated.');
    }

    public function bedCategoryEdit(Request $request,$id){
        $bedCategory = BedCategory::find($id);
        return response()->json($bedCategory);
    }

    public function bedCategoryDelete(Request $request,$id){
        $bedCategory = BedCategory::find($id);
        $bedCategory->delete();
        return redirect()->back()->with('success','Bed Category Deleted.');
    }

}
