<?php

namespace App\Http\Controllers\Hms;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\DoctorAppoinment;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;
use App\User;
use Illuminate\Support\Facades\Hash;

class AppoinmentController extends Controller
{

    public function telecommunication(Request $request)
    {
        if ($request->has('patient')) {
            $DoctorAppoinment = DoctorAppoinment::where('patient_id', Auth::user()->id)->latest()->get();
            $pendingDoctorAppoinment = DoctorAppoinment::where('patient_id', Auth::user()->id)->where('appoinment_status', 'Pending Confirmation')->latest()->get();
            $confirmDoctorAppoinment = DoctorAppoinment::where('patient_id', Auth::user()->id)->where('appoinment_status', 'Confirmed')->latest()->get();
            $teatedDoctorAppoinment = DoctorAppoinment::where('patient_id', Auth::user()->id)->where('appoinment_status', 'Treated')->latest()->get();
            $CancelledDoctorAppoinment = DoctorAppoinment::where('patient_id', Auth::user()->id)->where('appoinment_status', 'Cancelled')->latest()->get();
            $RequestedDoctorAppoinment = DoctorAppoinment::where('patient_id', Auth::user()->id)->where('appoinment_status', 'Requested')->latest()->get();
            // dd($DoctorAppoinment);
        } else {
            $DoctorAppoinment = DoctorAppoinment::latest()->get();
            $pendingDoctorAppoinment = DoctorAppoinment::where('appoinment_status', 'Pending Confirmation')->latest()->get();
            $confirmDoctorAppoinment = DoctorAppoinment::where('appoinment_status', 'Confirmed')->latest()->get();
            $teatedDoctorAppoinment = DoctorAppoinment::where('appoinment_status', 'Treated')->latest()->get();
            $CancelledDoctorAppoinment = DoctorAppoinment::where('appoinment_status', 'Cancelled')->latest()->get();
            $RequestedDoctorAppoinment = DoctorAppoinment::where('appoinment_status', 'Requested')->latest()->get();
        }

        return view('hms.telecommunication', compact('DoctorAppoinment', 'pendingDoctorAppoinment', 'confirmDoctorAppoinment', 'teatedDoctorAppoinment', 'CancelledDoctorAppoinment', 'RequestedDoctorAppoinment'));

    }

    public function appointment(Request $request)
    {
        if ($request->has('patient')) {
            $DoctorAppoinment = DoctorAppoinment::with('doctor', 'patient')->where('patient_id', Auth::user()->id)->latest()->get();
            $pendingDoctorAppoinment = DoctorAppoinment::where('patient_id', Auth::user()->id)->where('appoinment_status', 'Pending Confirmation')->latest()->get();
            $confirmDoctorAppoinment = DoctorAppoinment::where('patient_id', Auth::user()->id)->where('appoinment_status', 'Confirmed')->latest()->get();
            $teatedDoctorAppoinment = DoctorAppoinment::where('patient_id', Auth::user()->id)->where('appoinment_status', 'Treated')->latest()->get();
            $CancelledDoctorAppoinment = DoctorAppoinment::where('patient_id', Auth::user()->id)->where('appoinment_status', 'Cancelled')->latest()->get();
            $RequestedDoctorAppoinment = DoctorAppoinment::where('patient_id', Auth::user()->id)->where('appoinment_status', 'Requested')->latest()->get();
            // dd($DoctorAppoinment);
        } else {
            $DoctorAppoinment = DoctorAppoinment::with('doctor', 'patient')->latest()->get();
            $pendingDoctorAppoinment = DoctorAppoinment::where('appoinment_status', 'Pending Confirmation')->latest()->get();
            $confirmDoctorAppoinment = DoctorAppoinment::where('appoinment_status', 'Confirmed')->latest()->get();
            $teatedDoctorAppoinment = DoctorAppoinment::where('appoinment_status', 'Treated')->latest()->get();
            $CancelledDoctorAppoinment = DoctorAppoinment::where('appoinment_status', 'Cancelled')->latest()->get();
            $RequestedDoctorAppoinment = DoctorAppoinment::where('appoinment_status', 'Requested')->latest()->get();
        }
        return view('hms.appointment', compact('DoctorAppoinment', 'pendingDoctorAppoinment', 'confirmDoctorAppoinment', 'teatedDoctorAppoinment', 'CancelledDoctorAppoinment', 'RequestedDoctorAppoinment'));

    }

    public function getAppointmentByDoctorId(Request $request, $id)
    {
        $events = DoctorAppoinment::where('doctor_id', $id)->get();
        $doctor = User::find($id);
        $evnt_array = [];
        foreach ($events as $item) {
            $temp['id'] = $item->patient_id;
            $temp['title'] = "<div style='padding:5px;display:block;'>" .
                "<br> Status: " . $item->appoinment_status .
                "<br> Patient: " . User::find($item->patient_id)->name .

                "<br> Phone: " . User::find($item->patient_id)->phone .
                "<br> Doctor: " . User::find($item->doctor_id)->name .
                "<br> Remarks: " . $item->remarks .
                "</div>";
            $temp['description'] = "Click to see the patient history";
            $temp['start'] = $item->start;
            $temp['end'] = $item->end;
            $temp['color'] = '#' . rand(100000, 999999);

            array_push($evnt_array, $temp);
        }
        return view('hms.getAppointmentByDoctorId', compact('evnt_array', 'doctor', 'events'));
    }

    public function addNewView(Request $request)
    {
        return view('hms.addNewView');
    }
    public function todays(Request $request)
    {
        return view('hms.todays');
    }
    public function upcoming(Request $request)
    {
        return view('hms.upcoming');
    }
    public function calendar(Request $request)
    {
        $events = DoctorAppoinment::get();
        $evnt_array = [];
        foreach ($events as $item) {
            $check_patient = User::where('id', $item->patient_id)->exists();
            if ($check_patient) {
                $temp['id'] = $item->patient_id;
                $temp['title'] = "<div style='padding:5px;display:block;'>" .
                    "<br> Status: " . $item->appoinment_status .
                    "<br> Patient: " . User::find($item->patient_id)->name .
                    "<br> Phone: " . User::find($item->patient_id)->phone .
                    "<br> Doctor: " . User::find($item->doctor_id)->name .
                    "<br> Remarks: " . $item->remarks .
                    "</div>";
                $temp['description'] = "Click to see the patient history";
                $temp['start'] = $item->start;
                $temp['end'] = $item->end;
                $temp['color'] = '#' . rand(100000, 999999);

                array_push($evnt_array, $temp);
            }
        }
        // dd(json_encode($evnt_array));
        return view('hms.calendar', compact('evnt_array'));
    }
    public function request(Request $request)
    {
        return view('hms.request');
    }

    public function meeting(Request $request)
    {
        return view('hms.appointment_meeting');
    }

    public function treatmentReport(Request $request)
    {
        return view('hms.appoinment_treatment');
    }

    public function store_doctor_appointment(Request $request)
    {
        $this->validate($request, [
            'doctor_id' => ['required'],
            'appoinment_date' => ['required'],
            'appoinment_time' => ['required'],
            'remarks' => ['required'],
        ]);

        $patient_id = $request->patient_id;
        if (!($request->p_name == null) && !($request->p_phone == null)) {
            $this->validate($request, [
                'p_name' => ['required'],
                'p_phone' => ['required'],
                'p_age' => ['required'],
                'p_gender' => ['required'],
            ]);
            $user = new User();
            $user->name = $request->p_name;
            $user->role_id = 8;
            if (is_null($request->p_email)) {
                $user->email = uniqid(5) . '_patient@gmail.com';
            } else {
                $user->email = $request->p_email;
            }
            $user->phone = $request->p_phone;
            $user->age = $request->p_age;
            $user->sex = $request->p_gender;
            $user->password = Hash::make(12345678);
            $user->created_at = Carbon::now()->toDateTimeString();
            $user->save();
            if (is_null($request->p_email)) {
                $user->email = $user->id . '_patient@gmail.com';
                $user->save();
            }
            $patient_id = $user->id;
        }

        $schedule = new DoctorAppoinment();
        $schedule->patient_id = $patient_id;
        $schedule->doctor_id = $request->doctor_id;
        $schedule->slots = $request->slots;
        $schedule->appoinment_date = $request->appoinment_date;
        $schedule->appoinment_time = explode('|', $request->appoinment_time)[0];
        $schedule->start = $request->appoinment_date . ' ' . explode('|', $request->appoinment_time)[1];
        $schedule->end = $request->appoinment_date . ' ' . explode('|', $request->appoinment_time)[2];
        $schedule->appoinment_status = $request->appoinment_status;
        $schedule->remarks = $request->remarks;
        $schedule->creator = Auth::user()->id;
        $schedule->created_at = Carbon::now()->toDateTimeString();

        $schedule->save();
        $schedule->slug = $schedule->id . '_' . uniqid(10);
        $schedule->save();

        return redirect()->back()->with('success', 'New Appoinment added');
    }

    public function update_doctor_appointment(Request $request)
    {
        $this->validate($request, [
            'doctor_id' => ['required'],
            'appoinment_date' => ['required'],
            'appoinment_time' => ['required'],
            'remarks' => ['required'],
        ]);
        // dd($request->request);
        $schedule = DoctorAppoinment::find($request->id);
        $schedule->patient_id = $request->patient_id;
        $schedule->doctor_id = $request->doctor_id;
        $schedule->slots = $request->slots;
        $schedule->appoinment_date = $request->appoinment_date;
        $schedule->appoinment_time = explode('|', $request->appoinment_time)[0];
        $schedule->start = $request->appoinment_date . ' ' . explode('|', $request->appoinment_time)[1];
        $schedule->end = $request->appoinment_date . ' ' . explode('|', $request->appoinment_time)[2];
        $schedule->appoinment_status = $request->appoinment_status;
        $schedule->remarks = $request->remarks;
        $schedule->creator = Auth::user()->id;
        $schedule->updated_at = Carbon::now()->toDateTimeString();

        $schedule->save();

        return redirect()->back()->with('success', 'appoinment updated');
    }

    public function accept_doctor_appointment(Request $request)
    {
        $schedule = DoctorAppoinment::find($request->id);
        $schedule->appoinment_status = $request->appoinment_status;
        $schedule->creator = Auth::user()->id;
        $schedule->updated_at = Carbon::now()->toDateTimeString();

        $schedule->save();

        return redirect()->back()->with('success', 'Appoinment Accepted');
    }

    public function edit(Request $request, $id)
    {
        $schedule = DoctorAppoinment::find($id);
        return response()->json($schedule);
    }
    public function delete(Request $request, $id)
    {
        $doctor = DoctorAppoinment::find($id);
        $doctor->delete();
        return redirect()->back()->with('success', 'appoinment deleted');
    }
}