<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\User;
use Carbon\Carbon;
use Illuminate\Support\Facades\Hash;
use App\DoctorAppoinment;
use App\FrontendContactHospital;
use App\Mail\quoteMail;
use Illuminate\Support\Facades\Mail;

class FrontendEndController extends Controller
{
    public function index(Request $request){
        return view('frontend.index');
    }

    public function about(Request $request){
        return view('frontend.about');
    }

    public function department(Request $request){
        return view('frontend.department');
    }

    public function department_details(Request $request){
        return view('frontend.department_details');
    }

    public function doctor(Request $request){
        return view('frontend.doctor');
    }

    public function doctor_details(Request $request,$slug){
        $user = User::where('slug',$slug)->firstOrFail();
        return view('frontend.doctor_details',compact('user'));
    }

    public function doctor_appoinment(Request $request){
        if ($request->has('slug')) {
            $user = User::where('slug',$request->slug)->firstOrFail();
        }else{
            $user = null;
        }
        return view('frontend.appoinment',compact('user'));
    }

    public function doctor_appoinment_submit(Request $request){
        $this->validate($request, [
            'name' => ['required', 'string', 'max:255'],
            'email' => ['nullable','string', 'max:255'],
            'phone' => ['required']
        ]);

        // dd($request->request);


        if ($request->email != null && User::where('email',$request->email)->exists()) {
            $user = User::where('email',$request->email)->firstOrFail();
        }else{
            $user = new User();
            $user->name = $request->name;
            $user->phone = $request->phone;
            if($request->has('email') && $request->email != null){
                $user->email = $request->email;
            }else{
                $user->email = time().'@gmail.com';
            }
            $user->role_id = 8;
            $user->sex = $request->sex;
            $user->patient_doctor = $request->doctor_id;
            $user->created_at = Carbon::now()->toDateTimeString();
            $user->password = Hash::make(12345678);
            $user->save();
            $user->slug = $user->id . '_' . uniqid(10);
            $user->email = $user->id.'@gmail.com';
            $user->save();
        }

        $schedule = new DoctorAppoinment();
        $schedule->patient_id = $user->id;
        $schedule->doctor_id = $request->doctor_id;
        $schedule->slots = $request->time;
        $schedule->appoinment_date = $request->date;
        $schedule->appoinment_time = explode('|',$request->time)[0];
        $schedule->start = $request->date.' '.explode('|',$request->time)[1];
        $schedule->end = $request->date.' '.explode('|',$request->time)[2];
        $schedule->appoinment_status = 'Pending Confirmation';
        $schedule->remarks = $request->remarks;
        $schedule->creator = $user->id;
        $schedule->created_at = Carbon::now()->toDateTimeString();
        $schedule->save();
        $schedule->slug = $schedule->id.'_'.uniqid(10);
        $schedule->save();

        return redirect()->back()->with('success','Your Appoinment added successfully.');
    }

    public function blog(Request $request){
        return view('frontend.blog');
    }

    public function blog_details(Request $request){
        return view('frontend.blog_details');
    }

    public function contact(Request $request){
        return view('frontend.contact');
    }

    public function contact_submit(Request $request){
        $this->validate($request,[
            'first_name' => ['required'],
            'last_name' => ['required'],
            'phone' => ['required'],
            'subject' => ['required'],
            'message' => ['required']
        ]);

        $contact = new FrontendContactHospital();
        $contact->first_name = $request->first_name;
        $contact->last_name = $request->last_name;
        $contact->email = $request->email;
        $contact->phone = $request->phone;
        $contact->subject = $request->subject;
        $contact->message = strip_tags($request->message);
        $contact->created_at = Carbon::now()->toDateTimeString();
        $contact->save();
        $contact->slug = $contact->id.'_'.uniqid(10);
        $contact->save();

        Mail::to('support@smartcarehms.com')->send(new quoteMail($contact) );
        Mail::to('bizdev@freeworldimports.com')->send(new quoteMail($contact) );

        return redirect()->back()->with('success','Thanks for your feed back.');
    }
}
